/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.contenttype;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.contenttype.CalendarContentEntityAdapter;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.wrapper.SpacePermissionsManagerWrapper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarPermissionDelegate
implements PermissionDelegate<CustomContentEntityObject> {
    private final CalendarPermissionManager calendarPermissionManager;
    private final CalendarContentEntityAdapter calendarContentEntityAdapter;
    private final CalendarManager calendarManager;
    private final SpacePermissionsManagerWrapper spacePermissionsManagerWrapper;
    private final PermissionManager permissionManager;

    @Autowired
    public CalendarPermissionDelegate(CalendarPermissionManager calendarPermissionManager, CalendarContentEntityAdapter calendarContentEntityAdapter, CalendarManager calendarManager, SpacePermissionsManagerWrapper spacePermissionsManagerWrapper, PermissionManager permissionManager) {
        this.calendarPermissionManager = calendarPermissionManager;
        this.calendarContentEntityAdapter = calendarContentEntityAdapter;
        this.calendarManager = calendarManager;
        this.spacePermissionsManagerWrapper = spacePermissionsManagerWrapper;
        this.permissionManager = permissionManager;
    }

    private Optional<PersistedSubCalendar> getPersistedSubcalendarFromCCEO(CustomContentEntityObject target) {
        String subCalendarId = this.calendarContentEntityAdapter.getSubCalendarId(target);
        return this.calendarManager.getPersistedSubCalendar(subCalendarId);
    }

    public boolean canView(ConfluenceUser user, CustomContentEntityObject target) {
        Optional<PersistedSubCalendar> persistedSubCalendarOptional = this.getPersistedSubcalendarFromCCEO(target);
        return (Boolean)persistedSubCalendarOptional.transform(persistedSubCalendar -> this.calendarPermissionManager.hasViewEventPrivilege(persistedSubCalendar, user)).or((Object)false);
    }

    public boolean canView(ConfluenceUser user) {
        return this.spacePermissionsManagerWrapper.getUseConfluencePermission(user);
    }

    public boolean canEdit(ConfluenceUser user, CustomContentEntityObject target) {
        Optional<PersistedSubCalendar> persistedSubCalendarOptional = this.getPersistedSubcalendarFromCCEO(target);
        return (Boolean)persistedSubCalendarOptional.transform(persistedSubCalendar -> this.calendarPermissionManager.hasEditEventPrivilege(persistedSubCalendar, user)).or((Object)false);
    }

    public boolean canSetPermissions(ConfluenceUser user, CustomContentEntityObject target) {
        return this.canAdminister(user, target);
    }

    public boolean canRemove(ConfluenceUser user, CustomContentEntityObject target) {
        Optional<PersistedSubCalendar> persistedSubCalendarOptional = this.getPersistedSubcalendarFromCCEO(target);
        return (Boolean)persistedSubCalendarOptional.transform(persistedSubCalendar -> this.calendarPermissionManager.hasDeleteSubCalendarPrivilege(persistedSubCalendar, user)).or((Object)false);
    }

    public boolean canExport(ConfluenceUser user, CustomContentEntityObject target) {
        return this.canView(user, target);
    }

    public boolean canAdminister(ConfluenceUser user, CustomContentEntityObject target) {
        Optional<PersistedSubCalendar> persistedSubCalendarOptional = this.getPersistedSubcalendarFromCCEO(target);
        return (Boolean)persistedSubCalendarOptional.transform(persistedSubCalendar -> this.calendarPermissionManager.hasAdminSubCalendarPrivilege(persistedSubCalendar, user)).or((Object)false);
    }

    public boolean canCreate(ConfluenceUser user, Object container) {
        return this.permissionManager.hasPermissionNoExemptions(user, Permission.VIEW, container);
    }

    public boolean canCreateInTarget(ConfluenceUser user, Class aClass) {
        throw new UnsupportedOperationException();
    }
}

