/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.exception;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CalendarException
extends RuntimeException {
    private final String errorMessageKey;
    private final List<Object> errorMessageSubstitutionsList;
    private final String message;
    private final boolean isCustomError;
    private final int status;

    public CalendarException(String message) {
        this.message = message;
        this.errorMessageKey = null;
        this.errorMessageSubstitutionsList = Collections.emptyList();
        this.isCustomError = false;
        this.status = 0;
    }

    public CalendarException(String message, boolean isCustomError) {
        this.message = message;
        this.errorMessageKey = null;
        this.errorMessageSubstitutionsList = Collections.emptyList();
        this.isCustomError = isCustomError;
        this.status = 0;
    }

    public CalendarException(String errorMessageKey, Object ... errorMessageSubstitutions) {
        this.message = null;
        this.errorMessageKey = errorMessageKey;
        this.errorMessageSubstitutionsList = null != errorMessageSubstitutions ? Collections.unmodifiableList(Arrays.asList(errorMessageSubstitutions)) : Collections.emptyList();
        this.isCustomError = false;
        this.status = 0;
    }

    public CalendarException(Exception cause, String errorMessageKey, Object ... errorMessageSubstitutions) {
        this.message = null;
        this.errorMessageKey = errorMessageKey;
        this.errorMessageSubstitutionsList = null != errorMessageSubstitutions ? Collections.unmodifiableList(Arrays.asList(errorMessageSubstitutions)) : Collections.emptyList();
        this.isCustomError = false;
        this.status = 0;
        if (null != cause) {
            this.initCause(cause);
        }
    }

    public CalendarException(Exception cause, boolean isCustomError, String errorMessageKey, Object ... errorMessageSubstitutions) {
        this.message = null;
        this.errorMessageKey = errorMessageKey;
        this.errorMessageSubstitutionsList = null != errorMessageSubstitutions ? Collections.unmodifiableList(Arrays.asList(errorMessageSubstitutions)) : Collections.emptyList();
        this.isCustomError = isCustomError;
        this.status = 0;
        if (null != cause) {
            this.initCause(cause);
        }
    }

    public CalendarException(Exception cause, boolean isCustomError, int status, String errorMessageKey, Object ... errorMessageSubstitutions) {
        this.message = null;
        this.errorMessageKey = errorMessageKey;
        this.errorMessageSubstitutionsList = null != errorMessageSubstitutions ? Collections.unmodifiableList(Arrays.asList(errorMessageSubstitutions)) : Collections.emptyList();
        this.isCustomError = isCustomError;
        this.status = status;
        if (null != cause) {
            this.initCause(cause);
        }
    }

    public List<?> getErrorMessageSubstitutions() {
        return this.errorMessageSubstitutionsList;
    }

    public String getErrorMessageKey() {
        return StringUtils.defaultString((String)this.errorMessageKey);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean isCustomError() {
        return this.isCustomError;
    }

    public int getStatus() {
        return this.status;
    }

    public static enum StatusError {
        JQL_WRONG(1);

        private final int statusNum;

        private StatusError(int statusNum) {
            this.statusNum = statusNum;
        }

        public int getStatusNum() {
            return this.statusNum;
        }
    }
}

