/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.license;

import com.atlassian.confluence.extra.calendar3.JodaIcal4jTimeZoneMapper;
import com.atlassian.confluence.extra.calendar3.license.ConfluenceLicenseHelper;
import com.atlassian.confluence.extra.calendar3.license.LicenseAbstract;
import com.atlassian.confluence.extra.calendar3.license.LicenseAccessor;
import com.atlassian.confluence.extra.calendar3.license.LicenseServiceProvider;
import com.atlassian.confluence.extra.calendar3.license.UserCountCache;
import com.atlassian.confluence.extra.calendar3.util.BuildInformationManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.license.LicenseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.license.compatibility.CompatibleLicenseStatus;
import com.atlassian.upm.license.compatibility.LegacyCompatiblePluginLicenseManager;
import com.google.common.base.Throwables;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class DefaultPluginLicenseManager
implements LegacyCompatiblePluginLicenseManager {
    private static final String LICENSE_KEY = LicenseAccessor.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPluginLicenseManager.class);
    private final ConfluenceLicenseHelper confluenceLicenseHelper;
    private final PluginSettings pluginSettings;
    private final BuildInformationManager buildInformationManager;
    private final LocaleManager localeManager;
    private final LicenseServiceProvider licenseServiceProvider;
    private final UserCountCache userCountCache;
    private final JodaIcal4jTimeZoneMapper jodaIcal4jTimeZoneMapper;

    @Autowired
    public DefaultPluginLicenseManager(ConfluenceLicenseHelper confluenceLicenseHelper, @ComponentImport @Qualifier(value="pluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory, BuildInformationManager buildInformationManager, @ComponentImport LocaleManager localeManager, UserCountCache userCountCache, JodaIcal4jTimeZoneMapper jodaIcal4jTimeZoneMapper, LicenseServiceProvider licenseServiceProvider) {
        this.confluenceLicenseHelper = confluenceLicenseHelper;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.buildInformationManager = buildInformationManager;
        this.localeManager = localeManager;
        this.userCountCache = userCountCache;
        this.jodaIcal4jTimeZoneMapper = jodaIcal4jTimeZoneMapper;
        this.licenseServiceProvider = licenseServiceProvider;
    }

    public ProductLicense setLicense(String rawLicense) {
        if (rawLicense == null) {
            this.pluginSettings.remove(LICENSE_KEY);
            return null;
        }
        ProductLicense license = this.getLicense(rawLicense);
        if (license != null) {
            this.pluginSettings.put(LICENSE_KEY, (Object)rawLicense);
        }
        return license;
    }

    public ProductLicense getCurrentLicense() {
        LicenseAbstract confluenceLicenseAbstract = this.getConfluenceLicenseAbstract();
        if (this.isPiggyBackingOnConfluenceEvaluationLicense(confluenceLicenseAbstract) || !this.isLicenseSetup()) {
            return null;
        }
        return this.getValidatedLicense();
    }

    private ProductLicense getValidatedLicense() {
        try {
            return this.getLicenseService().validate(this.getCalendarPluginLicenseString(), Product.TEAM_CALENDARS);
        }
        catch (Exception ex) {
            Throwables.throwIfUnchecked((Throwable)ex);
            throw new com.atlassian.confluence.license.exception.LicenseException(ex.getMessage(), (Throwable)ex);
        }
    }

    public ProductLicense getLicense(String rawLicense) {
        ProductLicense tcLicense = null;
        try {
            tcLicense = this.getLicenseService().validate(StringUtils.defaultString((String)rawLicense), Product.TEAM_CALENDARS);
        }
        catch (Exception licenseError) {
            LOG.error("Unable to read Team Calendars license string", (Throwable)licenseError);
        }
        return tcLicense;
    }

    public CompatibleLicenseStatus getCurrentLicenseStatus() {
        if (!this.isLicenseSetup()) {
            return CompatibleLicenseStatus.INACTIVE;
        }
        return this.getInvalidLicenseReasonsInternal(this.getLicenseAbstract());
    }

    public CompatibleLicenseStatus getLicenseStatus(String rawLicense) {
        ProductLicense license = this.getLicense(rawLicense);
        if (license == null) {
            return CompatibleLicenseStatus.INVALID;
        }
        LicenseAbstract calendarPluginLicenseAbstract = new LicenseAbstract(license, this.jodaIcal4jTimeZoneMapper, this.localeManager);
        return this.getInvalidLicenseReasonsInternal(calendarPluginLicenseAbstract);
    }

    public URI getPluginLicenseAdministrationUri() {
        return URI.create("/admin/calendar/viewlicense.action");
    }

    private LicenseAbstract getLicenseAbstract() {
        ProductLicense tcLicense = null;
        LicenseAbstract confluenceLicenseAbstract = this.getConfluenceLicenseAbstract();
        if (this.isPiggyBackingOnConfluenceEvaluationLicense(confluenceLicenseAbstract)) {
            return confluenceLicenseAbstract;
        }
        if (this.isLicenseSetup()) {
            tcLicense = this.getValidatedLicense();
        }
        return new LicenseAbstract(tcLicense, this.jodaIcal4jTimeZoneMapper, this.localeManager);
    }

    private LicenseService getLicenseService() {
        return this.licenseServiceProvider.getLicenseService();
    }

    private String getCalendarPluginLicenseString() {
        return this.getStoredLicense();
    }

    private String getStoredLicense() {
        LOG.debug("Getting license from Plugin Settings");
        return (String)this.pluginSettings.get(LICENSE_KEY);
    }

    private boolean isLicenseSetup() {
        return this.isPiggyBackingOnConfluenceEvaluationLicense() || StringUtils.isNotBlank((CharSequence)this.getStoredLicense());
    }

    private CompatibleLicenseStatus getInvalidLicenseReasonsInternal(LicenseAbstract calendarPluginLicenseAbstract) {
        String calendarPluginLicenseType = calendarPluginLicenseAbstract.getLicenseType();
        if (null == calendarPluginLicenseType) {
            return CompatibleLicenseStatus.INVALID;
        }
        LicenseAbstract confluenceLicenseAbstract = this.getConfluenceLicenseAbstract();
        String confluenceLicenseType = confluenceLicenseAbstract.getLicenseType();
        if (!(calendarPluginLicenseAbstract.isEvaluation() || confluenceLicenseAbstract.isEvaluation() || StringUtils.equals((CharSequence)calendarPluginLicenseType, (CharSequence)confluenceLicenseType))) {
            return CompatibleLicenseStatus.INCOMPATIBLE_TYPE;
        }
        int maxActiveUsersAllowed = calendarPluginLicenseAbstract.getNumberOfUserLicensed();
        int activeUsers = this.userCountCache.getActiveUserCount();
        if (-1 != maxActiveUsersAllowed && activeUsers > maxActiveUsersAllowed) {
            return CompatibleLicenseStatus.USER_MISMATCH;
        }
        if (calendarPluginLicenseAbstract.isExpired()) {
            return calendarPluginLicenseAbstract.isEvaluation() ? CompatibleLicenseStatus.EVALUATION_EXPIRED : CompatibleLicenseStatus.EXPIRED;
        }
        if (calendarPluginLicenseAbstract.isMaintenanceExpired() && this.buildInformationManager.getBuildDate().isAfter((ReadableInstant)calendarPluginLicenseAbstract.getMaintenanceExpiry())) {
            return CompatibleLicenseStatus.MAINTENANCE_EXPIRED;
        }
        return calendarPluginLicenseAbstract.isEvaluation() ? CompatibleLicenseStatus.EVALUATION : CompatibleLicenseStatus.ACTIVE;
    }

    private boolean isPiggyBackingOnConfluenceEvaluationLicense(LicenseAbstract confluenceLicenseAbstract) {
        return StringUtils.isBlank((CharSequence)this.getStoredLicense()) && confluenceLicenseAbstract.isEvaluation() && !confluenceLicenseAbstract.isExpired();
    }

    private LicenseAbstract getConfluenceLicenseAbstract() {
        ConfluenceLicense confluenceLicense = null;
        try {
            confluenceLicense = this.getLicenseService().validate(this.getProductLicenseString());
        }
        catch (Exception confluenceLicenseProblem) {
            LOG.error("There seems to be a problem with the Confluence license...", (Throwable)confluenceLicenseProblem);
        }
        return new LicenseAbstract((ProductLicense)confluenceLicense, this.jodaIcal4jTimeZoneMapper, this.localeManager);
    }

    private String getProductLicenseString() throws LicenseException {
        return this.confluenceLicenseHelper.getProductLicenseString();
    }

    private boolean isPiggyBackingOnConfluenceEvaluationLicense() {
        return this.isPiggyBackingOnConfluenceEvaluationLicense(this.getConfluenceLicenseAbstract());
    }
}

