/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.notification;

import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.calendar3.notification.DefaultCalendarNotificationManager;
import com.atlassian.confluence.extra.calendar3.notification.IdentifiableContentDataSource;
import com.atlassian.confluence.extra.calendar3.notification.ProfilePictureConst;
import com.atlassian.confluence.extra.calendar3.notification.ResourceDataHandler;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultResourceDataHandler
implements ResourceDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceDataHandler.class);
    private final UserAccessor userAccessor;
    private final PersonalInformationManager personalInformationManager;
    private final AttachmentManager attachmentManager;
    private final DataSourceFactory dataSourceFactory;

    @Autowired
    public DefaultResourceDataHandler(@ComponentImport UserAccessor userAccessor, @ComponentImport PersonalInformationManager personalInformationManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport DataSourceFactory dataSourceFactory) {
        this.userAccessor = userAccessor;
        this.personalInformationManager = personalInformationManager;
        this.attachmentManager = attachmentManager;
        this.dataSourceFactory = dataSourceFactory;
    }

    @Override
    public IdentifiableContentDataSource createAvatarDataHandler(ConfluenceUser user, Map<String, String> params) {
        UserPreferences propertySet = this.userAccessor.getUserPreferences(user);
        StringBuilder stringBuilder = new StringBuilder();
        String profilePicture = propertySet.getString("confluence.user.profile.picture").orElse(null);
        if (profilePicture == null) {
            return this.createDefaultProfilePictureDataHandler(params);
        }
        if (profilePicture.startsWith("/images/icons/profilepics/")) {
            String contentId;
            try {
                contentId = DigestUtils.sha1Hex((byte[])profilePicture.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                LOG.error("Failed to get contentId for {}", (Object)profilePicture, (Object)ex);
                return null;
            }
            if (null != params && !params.isEmpty()) {
                contentId = stringBuilder.append(contentId).append('_').append(params.hashCode()).toString();
            }
            stringBuilder.setLength(0);
            String extension = profilePicture.lastIndexOf(46) >= 0 ? profilePicture.substring(profilePicture.lastIndexOf(46)) : "";
            return new IdentifiableContentDataSource(this.dataSourceFactory.getAvatar(user), contentId, stringBuilder.append(contentId).append(extension).toString());
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        if (null == personalInformation) {
            return this.createDefaultProfilePictureDataHandler(params);
        }
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)personalInformation, profilePicture);
        if (attachment != null) {
            return this.createAttachmentDataHandler(attachment, params);
        }
        return null;
    }

    @Override
    public IdentifiableContentDataSource createDefaultProfilePictureDataHandler(Map<String, String> params) {
        String profilePath = ProfilePictureConst.DEFAULT_PROFILE.getDownloadPath();
        String contentId = DigestUtils.sha1Hex((byte[])profilePath.getBytes(StandardCharsets.UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        if (null != params && !params.isEmpty()) {
            contentId = stringBuilder.append(contentId).append('_').append(params.hashCode()).toString();
        }
        stringBuilder.setLength(0);
        String extension = profilePath.lastIndexOf(46) >= 0 ? profilePath.substring(profilePath.lastIndexOf(46)) : "";
        try {
            return new IdentifiableContentDataSource(this.dataSourceFactory.getServletContainerResource(profilePath, "default.gif"), contentId, stringBuilder.append(contentId).append(extension).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IdentifiableContentDataSource createAvatarDataHandler(String userName, Map<String, String> params) {
        return this.createAvatarDataHandler(this.userAccessor.getUserByName(userName), params);
    }

    @Override
    public IdentifiableContentDataSource createAttachmentDataHandler(Attachment attachment, Map<String, String> params) {
        byte[] attachmentContent;
        try {
            attachmentContent = this.getAttachmentContentAsByteArray(attachment);
        }
        catch (IOException e) {
            LOG.warn("Failed to get content of attachment {} as byte array", (Object)attachment.getFileName(), (Object)e);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String contentId = DigestUtils.sha1Hex((byte[])attachmentContent);
        if (null != params && !params.isEmpty()) {
            contentId = stringBuilder.append(contentId).append(' ').append(params.hashCode()).toString();
        }
        stringBuilder.setLength(0);
        return new IdentifiableContentDataSource(new DefaultCalendarNotificationManager.ProfileImageDataSource(this.dataSourceFactory.getDataSource(attachmentContent, attachment.getMediaType())), contentId, stringBuilder.append(contentId).append('.').append(StringUtils.defaultString((String)attachment.getFileExtension())).toString());
    }

    private byte[] getAttachmentContentAsByteArray(Attachment attachment) throws IOException {
        try (InputStream attachmentInput = this.attachmentManager.getAttachmentData(attachment);){
            byte[] byArray = IOUtils.toByteArray((InputStream)attachmentInput);
            return byArray;
        }
    }
}

