/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.extra.calendar3.ActiveObjectsServiceWrapper;
import com.atlassian.confluence.extra.calendar3.model.rest.GeneralResponseEntity;
import com.atlassian.confluence.extra.calendar3.upgrade.task.aomigration.CalendarContentTypeMigrationManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="calendarcontenttype")
@ReadOnlyAccessAllowed
@WebSudoRequired
@Consumes(value={"application/json"})
public class CalendarContentTypeResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarContentTypeResource.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final CalendarContentTypeMigrationManager calendarContentTypeMigrationManager;
    private final ActiveObjectsServiceWrapper activeObjectsWrapper;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public CalendarContentTypeResource(CalendarContentTypeMigrationManager calendarContentTypeMigrationManager, ActiveObjectsServiceWrapper activeObjectsWrapper, @ComponentImport TransactionTemplate txnTemplate) {
        this.calendarContentTypeMigrationManager = calendarContentTypeMigrationManager;
        this.activeObjectsWrapper = activeObjectsWrapper;
        this.transactionTemplate = txnTemplate;
    }

    @Path(value="reindex")
    @POST
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response forceData() {
        return (Response)this.transactionTemplate.execute(() -> {
            GeneralResponseEntity responseEntity = new GeneralResponseEntity();
            try {
                boolean result = this.calendarContentTypeMigrationManager.deleteAllCalendarContentTypes() && this.calendarContentTypeMigrationManager.doMigrate(this.activeObjectsWrapper);
                responseEntity.setSuccess(result);
            }
            catch (Exception ex) {
                responseEntity.setSuccess(false);
                LOGGER.error("Exception happen when Reindex Calendar CustomContentTypes manually", (Throwable)ex);
            }
            return Response.status((Response.Status)Response.Status.OK).header(CONTENT_TYPE_HEADER, (Object)"application/json").entity((Object)responseEntity.toJson().toString()).build();
        });
    }
}

