/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.extra.calendar3.ActiveObjectsServiceWrapper;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.calendarstore.generic.DefaultChildSubCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.ical4j.VEventMapper;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.model.persistence.CustomEventTypeEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.DisableEventTypeEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.EventEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.EventRecurrenceExclusionEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.ExtraSubCalendarPropertyEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.InviteeEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.JiraReminderEventEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.ReminderSettingEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.ReminderUsersEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.SubCalendarEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.SubCalendarGroupRestrictionEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.SubCalendarInSpaceEntity;
import com.atlassian.confluence.extra.calendar3.model.persistence.SubCalendarUserRestrictionEntity;
import com.atlassian.confluence.extra.calendar3.model.rest.CalendarRestResult;
import com.atlassian.confluence.extra.calendar3.model.rest.RestStatusCode;
import com.atlassian.confluence.extra.calendar3.reminder.job.CalendarReminderJob;
import com.atlassian.confluence.extra.calendar3.util.Ical4jIoUtil;
import com.atlassian.plugins.rest.api.darkfeature.RequiresDarkFeature;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.java.ao.DBParam;
import net.java.ao.DatabaseProvider;
import net.java.ao.Query;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;

@Path(value="/calendar-test")
@RequiresDarkFeature(value={"tc.test.mode"})
@Produces(value={"application/json;charset=UTF-8"})
public class CalendarTestResource {
    private static final String CHARSET_DEFAULT = "UTF-8";
    private final ActiveObjectsServiceWrapper activeObjectsServiceWrapper;
    private final CalendarManager calendarManager;
    private final CalendarReminderJob calendarReminderJob;
    private final VEventMapper vEventMapper;

    @Inject
    public CalendarTestResource(ActiveObjectsServiceWrapper activeObjectsServiceWrapper, CalendarManager calendarManager, @Named(value="tcReminderJob") CalendarReminderJob calendarReminderJob, VEventMapper vEventMapper) {
        this.activeObjectsServiceWrapper = activeObjectsServiceWrapper;
        this.calendarManager = calendarManager;
        this.calendarReminderJob = calendarReminderJob;
        this.vEventMapper = vEventMapper;
    }

    @GET
    @Path(value="/denseCalendar")
    @Produces(value={"text/calendar; charset=UTF-8"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response createDenseCalendar(@QueryParam(value="numberEventPerDay") int numberEventPerDay) {
        DateTime firstDateOfCurrentMonth = new DateTime().withDayOfMonth(1);
        DateTime lastDateOfCurrentMonth = firstDateOfCurrentMonth.plusMonths(1);
        ArrayList<SubCalendarEvent> eventList = new ArrayList<SubCalendarEvent>(1000);
        DefaultChildSubCalendarDataStore.DefaultChildSubCalendar subCalendar = new DefaultChildSubCalendarDataStore.DefaultChildSubCalendar();
        while (firstDateOfCurrentMonth.isBefore((ReadableInstant)lastDateOfCurrentMonth)) {
            DateTime startDate = firstDateOfCurrentMonth;
            DateTime endDate = startDate.plusHours(2);
            for (int index = 0; index < numberEventPerDay; ++index) {
                SubCalendarEvent event = new SubCalendarEvent();
                event.setUid(UUID.randomUUID().toString());
                event.setSubCalendar((PersistedSubCalendar)subCalendar);
                event.setEventType("other");
                event.setEventTypeName("other");
                event.setAllDay(false);
                event.setName("Event " + (index + 1));
                event.setDescription(String.format("Event %d with period %s - %s", index + 1, startDate, endDate));
                event.setStartTime(startDate);
                event.setEndTime(endDate);
                eventList.add(event);
            }
            firstDateOfCurrentMonth = firstDateOfCurrentMonth.plusDays(1);
        }
        PropertyList calendarProperties = new PropertyList();
        ComponentList calendarComponents = new ComponentList();
        eventList.forEach(subCalendarEvent -> {
            VEvent event = this.vEventMapper.toVEvent(subCalendarEvent.getSubCalendar(), (SubCalendarEvent)subCalendarEvent);
            calendarComponents.add((Object)event);
        });
        Calendar calendar = new Calendar(calendarProperties, calendarComponents);
        Response.ResponseBuilder response = Response.ok(outputStream -> Ical4jIoUtil.newCalendarOutputter().output(calendar, outputStream));
        response.header("Content-Disposition", (Object)"attachment; filename=\"DenseCalendar.ics\"");
        return response.build();
    }

    @XsrfProtectionExcluded
    @GET
    @Produces(value={"application/json"})
    @Path(value="/reminder")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getReminderEvents() {
        List reminderEventList = this.calendarManager.getEventUpComingReminder();
        return Response.ok((Object)reminderEventList).build();
    }

    @XsrfProtectionExcluded
    @GET
    @Produces(value={"application/json"})
    @Path(value="/reminder/email/{millisecond}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response sendReminderEvents(@PathParam(value="millisecond") Long milliseconds) {
        this.calendarReminderJob.setReminderSupplier(() -> this.calendarManager.getEventUpComingReminder(milliseconds.longValue()));
        this.calendarReminderJob.execute();
        return Response.ok((Object)"email sent").build();
    }

    @XsrfProtectionExcluded
    @GET
    @Produces(value={"application/json"})
    @Path(value="/reminder/email/reset")
    @ScopesAllowed(requiredScope={"READ"})
    public Response resetReminder() {
        this.calendarReminderJob.resetReminderSupplier();
        return Response.ok((Object)"email sent").build();
    }

    @XsrfProtectionExcluded
    @GET
    @Produces(value={"application/json"})
    @Path(value="/reminder/{millisecond}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getReminderEvents(@PathParam(value="millisecond") Long milliseconds) {
        List reminderEventList = this.calendarManager.getEventUpComingReminder(milliseconds.longValue());
        return Response.ok((Object)reminderEventList).build();
    }

    @XsrfProtectionExcluded
    @GET
    @Produces(value={"application/json"})
    @Path(value="/reminder/startOfDay")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getReminderEventsAtStartOfDay() {
        DateTime systemUTCTime = new LocalDateTime(System.currentTimeMillis()).toDateTime(DateTimeZone.UTC).withTimeAtStartOfDay().minusMinutes(5);
        List reminderEventList = this.calendarManager.getEventUpComingReminder(systemUTCTime.getMillis());
        return Response.ok((Object)reminderEventList).build();
    }

    @XsrfProtectionExcluded
    @POST
    @Path(value="/reset")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response reset() {
        this.forceDeleteAllData(this.activeObjectsServiceWrapper);
        CalendarRestResult calendarRestResult = new CalendarRestResult.Builder().withStatusCode(RestStatusCode.OK).withErrorInfo(null).build();
        return Response.ok((Object)calendarRestResult).build();
    }

    @XsrfProtectionExcluded
    @POST
    @Path(value="/event/{eventId}/invitee/{numberOfInvitee}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createInviteeForEvent(@PathParam(value="eventId") String eventId, @PathParam(value="numberOfInvitee") int numberOfInvitee) {
        ActiveObjects activeObjects = this.activeObjectsServiceWrapper.getActiveObjects();
        EventEntity eventEntity = ((EventEntity[])activeObjects.find(EventEntity.class, "VEVENT_UID = ?", new Object[]{eventId}))[0];
        for (int i = 1; i <= numberOfInvitee; ++i) {
            activeObjects.create(InviteeEntity.class, new DBParam[]{new DBParam("EVENT_ID", (Object)eventEntity.getID()), new DBParam("INVITEE_ID", (Object)("TestInvitee-" + i))});
        }
        return Response.ok((Object)eventId).build();
    }

    @XsrfProtectionExcluded
    @POST
    @Path(value="/subcalendar/{subCalId}/event/{numberOfEvent}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createEventForSubCalendar(@PathParam(value="subCalId") String subCalId, @PathParam(value="numberOfEvent") int numberOfEvent) {
        for (int i = 1; i <= numberOfEvent; ++i) {
            VEvent testEvent = new VEvent(new Date(), new Date(), "test event " + i);
            this.activeObjectsServiceWrapper.createEventEntity(subCalId, testEvent);
        }
        return Response.ok((Object)subCalId).build();
    }

    public boolean forceDeleteAllData(ActiveObjectsServiceWrapper activeObjectsWrapper) {
        ActiveObjects activeObjects = activeObjectsWrapper.getActiveObjects();
        return (Boolean)activeObjects.executeInTransaction(() -> {
            activeObjects.deleteWithSQL(EventRecurrenceExclusionEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(ExtraSubCalendarPropertyEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(InviteeEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(SubCalendarGroupRestrictionEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(SubCalendarUserRestrictionEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(EventEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(DisableEventTypeEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(CustomEventTypeEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(ReminderSettingEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(ReminderUsersEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(JiraReminderEventEntity.class, null, new Object[0]);
            activeObjects.deleteWithSQL(SubCalendarInSpaceEntity.class, null, new Object[0]);
            SubCalendarEntity[] subCalendarEntities = (SubCalendarEntity[])activeObjects.find(SubCalendarEntity.class, Query.select().limit(1));
            if (subCalendarEntities != null && subCalendarEntities.length > 0) {
                DatabaseProvider currentDatabaseProvider = subCalendarEntities[0].getEntityManager().getProvider();
                activeObjects.deleteWithSQL(SubCalendarEntity.class, currentDatabaseProvider.quote("PARENT_ID") + " IS NOT NULL AND " + currentDatabaseProvider.quote("SUBSCRIPTION_ID") + " IS NOT NULL", new Object[0]);
                activeObjects.deleteWithSQL(SubCalendarEntity.class, currentDatabaseProvider.quote("PARENT_ID") + " IS NOT NULL", new Object[0]);
                activeObjects.deleteWithSQL(SubCalendarEntity.class, currentDatabaseProvider.quote("SUBSCRIPTION_ID") + " IS NOT NULL", new Object[0]);
                activeObjects.deleteWithSQL(SubCalendarEntity.class, null, new Object[0]);
            }
            return true;
        });
    }
}

