/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.extra.calendar3.HelpTipManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="tips")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class HelpTipResource {
    private static final Logger LOG = LoggerFactory.getLogger(HelpTipResource.class);
    private final HelpTipManager helpTipManager;

    @Inject
    public HelpTipResource(HelpTipManager helpTipManager) {
        this.helpTipManager = helpTipManager;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response index() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Collection<String> dismissedTips = this.helpTipManager.getDismissedTips((User)user);
        return Response.ok(dismissedTips).cacheControl(this.cacheControlNoCache()).build();
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response dismiss(Tooltip tooltip) {
        if (tooltip == null || tooltip.id == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControlNoCache()).build();
        }
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            this.helpTipManager.dismissTip((User)user, tooltip.id);
            return Response.noContent().cacheControl(this.cacheControlNoCache()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("dismissal of help tip failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControlNoCache()).build();
        }
    }

    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response undismiss(Tooltip tooltip) {
        if (tooltip == null || tooltip.id == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControlNoCache()).build();
        }
        try {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            this.helpTipManager.undismissTip((User)user, tooltip.id);
            return Response.noContent().cacheControl(this.cacheControlNoCache()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("undismissal of help tip failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(this.cacheControlNoCache()).build();
        }
    }

    private CacheControl cacheControlNoCache() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        return cacheControl;
    }

    @XmlRootElement
    public static class Tooltip {
        @XmlElement
        public String id;
    }
}

