/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.Interceptors;

import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=9000)
@Provider
@TeamCalResourceLogger
public class TeamCalResourceLoggingInterceptor
implements ReaderInterceptor {
    public static final int FILTER_PRIORITY = 9000;
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamCalResourceLoggingInterceptor.class);
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        String httpMethod = this.request != null ? this.request.getMethod() : "Unknown";
        String restURL = this.uriInfo != null ? this.uriInfo.getPath() : "Unknown";
        String logMessage = String.format("TeamCal rest endpoint %s invoked via http method %s", restURL, httpMethod);
        if (this.request != null && this.uriInfo != null) {
            LOGGER.info(logMessage);
        } else {
            LOGGER.error(logMessage);
        }
        return context.proceed();
    }
}

