/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.model.JiraDateField;
import com.atlassian.confluence.extra.calendar3.model.JqlValidationResult;
import com.atlassian.confluence.extra.calendar3.model.JsonSerializable;
import com.atlassian.confluence.extra.calendar3.model.QueryOptions;
import com.atlassian.confluence.extra.calendar3.rest.AbstractResource;
import com.atlassian.confluence.extra.calendar3.rest.JiraLinksResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.param.ValidateJQLParam;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;

@LicensedOnly
@Path(value="calendar/jira")
public class JiraCalendarResource
extends AbstractResource {
    private final JiraAccessor jiraAccessor;

    @Inject
    public JiraCalendarResource(CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, JiraAccessor jiraAccessor, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, UserAccessor userAccessor, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, txnTemplate);
        this.jiraAccessor = jiraAccessor;
    }

    @Path(value="jiraLinks")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraLinks() throws JSONException {
        return Response.ok((Object)new JiraLinksResponseEntity(this.jiraAccessor.getLinkedJiraApplications()).toJson().toString()).build();
    }

    @Path(value="{applicationId}/query/options")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraQueryOptions(@PathParam(value="applicationId") String applicationId) throws CredentialsRequiredException, ResponseException {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (null != jiraLink) {
            return Response.ok((Object)this.jiraAccessor.getQueryOptions(jiraLink).toJson().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="{applicationId}/date-fields/jql")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDateFieldsByJql(@PathParam(value="applicationId") String applicationId, @QueryParam(value="query") String jql) throws IOException, CredentialsRequiredException, ResponseException {
        JqlValidationResult jqlValidationResult;
        List<JiraDateField> jiraDateFields = Collections.emptyList();
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (jiraLink != null && StringUtils.isNotBlank((CharSequence)jql) && (jqlValidationResult = this.jiraAccessor.validateJql(jiraLink, jql)).isValid()) {
            jiraDateFields = this.getDateFieldsNormalized(jiraLink, this.jiraAccessor.getDateFields(jiraLink, jql));
        }
        return Response.ok((Object)this.toJsonArray((JsonSerializable[])jiraDateFields.toArray(new JiraDateField[jiraDateFields.size()])).toString()).build();
    }

    @Path(value="{applicationId}/date-fields/project/{projectKey}")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDateFieldsByProject(@PathParam(value="applicationId") String applicationId, @PathParam(value="projectKey") String projectKey) throws CredentialsRequiredException, IOException, ResponseException {
        return this.getDateFieldsByJql(applicationId, String.format("project = \"%s\"", projectKey));
    }

    @Path(value="{applicationId}/date-fields/filter/{searchFilterId}")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDateFieldsBySearchFilter(@PathParam(value="applicationId") String applicationId, @PathParam(value="searchFilterId") long searchFilterId) throws CredentialsRequiredException, ResponseException, IOException {
        List<JiraDateField> jiraDateFields = Collections.emptyList();
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (null != jiraLink) {
            QueryOptions queryOptions = this.jiraAccessor.getQueryOptions(jiraLink);
            List searchFilters = queryOptions.getSearchFilters();
            jiraDateFields = null != searchFilters && Collections2.filter((Collection)searchFilters, searchFilter -> searchFilterId == searchFilter.getId()).size() == 1 ? this.getDateFieldsNormalized(jiraLink, this.jiraAccessor.getDateFields(jiraLink, searchFilterId)) : this.getDateFieldsNormalized(jiraLink, jiraDateFields);
        }
        return Response.ok((Object)this.toJsonArray((JsonSerializable[])jiraDateFields.toArray(new JiraDateField[jiraDateFields.size()])).toString()).build();
    }

    @Path(value="{applicationId}/jql/validate")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response validateJql(@PathParam(value="applicationId") String applicationId, @BeanParam ValidateJQLParam param) throws IOException, CredentialsRequiredException, ResponseException {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (null != jiraLink) {
            return Response.ok((Object)this.jiraAccessor.validateJql(jiraLink, param.getJql()).toJson().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="{applicationId}/jql/autocomplete")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraAutocomplete(@PathParam(value="applicationId") String applicationId, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue) throws IOException, CredentialsRequiredException, ResponseException {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (null != jiraLink) {
            return Response.ok((Object)this.jiraAccessor.getAutoComplete(jiraLink, fieldName, fieldValue).toJson().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="{applicationId}/jql/autocompletedata")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraAutocompleteData(@PathParam(value="applicationId") String applicationId) throws CredentialsRequiredException, ResponseException {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (jiraLink != null) {
            return Response.ok((Object)this.jiraAccessor.getJqlAutoCompleteData(jiraLink).toJson().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="{applicationId}/jql/autocompletedata/suggestions")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJiraAutocompleteSuggestions(@PathParam(value="applicationId") String applicationId, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue) {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (jiraLink != null) {
            try {
                return Response.ok((Object)this.jiraAccessor.getAutoCompleteV2(jiraLink, fieldName, fieldValue).toJson().toString()).build();
            }
            catch (JSONException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Error when trying to parse JSON.").build();
            }
            catch (CredentialsRequiredException e) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Couldn't authorize.").build();
            }
            catch (ResponseException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't get response.").build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="{applicationId}/projects/picker")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response searchForProjects(@PathParam(value="applicationId") String applicationId, @QueryParam(value="query") String query, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="allowEmptyQuery") boolean allowEmptyQuery) throws CredentialsRequiredException, ResponseException {
        ApplicationLink jiraLink = this.jiraAccessor.getLinkedJiraInstance(applicationId);
        if (jiraLink != null) {
            return Response.ok((Object)this.jiraAccessor.searchForProjects(jiraLink, query, maxResults, allowEmptyQuery).toJson().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private List<JiraDateField> getDateFieldsNormalized(ApplicationLink jiraLink, Collection<JiraDateField> unsortedDateFields) {
        ArrayList<JiraDateField> normalizedDateFields = new ArrayList<JiraDateField>();
        normalizedDateFields.addAll(Collections2.filter((Collection)Collections2.transform(unsortedDateFields, (Function)new JiraDataFieldTranslationTransformer(this.getI18nBean())), jiraDateField -> !StringUtils.equals((CharSequence)jiraDateField.getKey(), (CharSequence)"updated")));
        if (normalizedDateFields.isEmpty()) {
            normalizedDateFields.add(new JiraDateField("duedate", this.getText("calendar3.jira.fields.duedate.name")));
        }
        normalizedDateFields.add(new JiraDateField("versiondue", this.getText("calendar3.jira.fields.versiondue.name")));
        normalizedDateFields.sort(Comparator.comparing(leftField -> StringUtils.defaultString((String)leftField.getName())).thenComparing(leftField -> StringUtils.defaultString((String)leftField.getKey())));
        this.setDateFieldOrder(normalizedDateFields, "duedate", 0);
        this.setDateFieldOrder(normalizedDateFields, "versiondue", 1);
        if (this.jiraAccessor.isGreenHopperSprintDatesSupported(jiraLink)) {
            normalizedDateFields.add(2, new JiraDateField("sprint", this.getText("calendar3.jira.fields.greenhoppersprint.name")));
        }
        return normalizedDateFields;
    }

    private void setDateFieldOrder(List<JiraDateField> jiraDateFields, String fieldKey, int newIndexInList) {
        if (newIndexInList < 0 || newIndexInList >= jiraDateFields.size()) {
            throw new IllegalArgumentException(String.format("New position %d out of range.", newIndexInList));
        }
        int index = -1;
        int j = jiraDateFields.size();
        for (int i = 0; i < j; ++i) {
            if (!StringUtils.equals((CharSequence)fieldKey, (CharSequence)jiraDateFields.get(i).getKey())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            jiraDateFields.add(newIndexInList, jiraDateFields.remove(index));
        }
    }

    private static class JiraDataFieldTranslationTransformer
    implements Function<JiraDateField, JiraDateField> {
        private final I18NBean i18NBean;
        private final StringBuilder i18nKeyBuilder;

        private JiraDataFieldTranslationTransformer(I18NBean i18NBean) {
            this.i18NBean = i18NBean;
            this.i18nKeyBuilder = new StringBuilder();
        }

        public JiraDateField apply(JiraDateField jiraDateField) {
            this.i18nKeyBuilder.setLength(0);
            String i18nKey = this.i18nKeyBuilder.append("calendar3.jira.fields.").append(jiraDateField.getKey()).append(".name").toString();
            String translatedName = this.i18NBean.getText(i18nKey);
            if (!StringUtils.equals((CharSequence)i18nKey, (CharSequence)translatedName)) {
                jiraDateField.setName(translatedName);
            }
            return jiraDateField;
        }
    }
}

