/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.extra.calendar3.CalendarTimeZonesProvider;
import com.atlassian.confluence.extra.calendar3.TimeZonesProvider;
import com.atlassian.confluence.extra.calendar3.UserTimeZonesProvider;
import com.atlassian.confluence.extra.calendar3.rest.TimeZonesResponseEntity;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Locale;

@Path(value="timezones")
public class TimezoneResource {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final UserTimeZonesProvider userTimeZonesProvider;
    private final CalendarTimeZonesProvider calendarTimeZonesProvider;
    private final LocaleManager localeManager;

    @Inject
    public TimezoneResource(LocaleManager localeManager, UserTimeZonesProvider userTimeZonesProvider, CalendarTimeZonesProvider calendarTimeZonesProvider) {
        this.localeManager = localeManager;
        this.userTimeZonesProvider = userTimeZonesProvider;
        this.calendarTimeZonesProvider = calendarTimeZonesProvider;
    }

    private Locale getUserLocale() {
        return this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get());
    }

    @Path(value="user")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getUserTimeZones() {
        return this.getTimeZones(this.userTimeZonesProvider);
    }

    @Path(value="calendar")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getCalendarTimeZones() {
        return this.getTimeZones(this.calendarTimeZonesProvider);
    }

    private Response getTimeZones(TimeZonesProvider timeZonesProvider) {
        return Response.status((Response.Status)Response.Status.OK).header(CONTENT_TYPE_HEADER, (Object)"application/json").entity((Object)new TimeZonesResponseEntity(timeZonesProvider.getAvailableTimeZones(), this.getUserLocale()).toJson().toString()).build();
    }
}

