/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.extra.calendar3.watchdog.WatchDogService;
import com.atlassian.confluence.extra.calendar3.watchdog.WatchDogServiceStatus;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="watchdog")
@ReadOnlyAccessAllowed
@WebSudoRequired
@Consumes(value={"application/json"})
public class WatchDogResource {
    private final WatchDogService watchDogService;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public WatchDogResource(WatchDogService watchDogService, @ComponentImport TransactionTemplate txnTemplate) {
        this.watchDogService = watchDogService;
        this.transactionTemplate = txnTemplate;
    }

    @Path(value="start")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response startWatchDogService() {
        return (Response)this.transactionTemplate.execute(() -> {
            WatchDogServiceStatus status = this.watchDogService.startService();
            return Response.ok((Object)status).build();
        });
    }

    @Path(value="status")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getStatus() {
        WatchDogServiceStatus status = this.watchDogService.getStatus();
        return Response.ok((Object)status).build();
    }
}

