/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.CalendarRenderer;
import com.atlassian.confluence.extra.calendar3.PrivateCalendarUrlManager;
import com.atlassian.confluence.extra.calendar3.SubCalendarSubscriptionStatisticsAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.InternalSubscriptionCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.contenttype.CalendarContentTypeManager;
import com.atlassian.confluence.extra.calendar3.events.SubCalendarAddedNew;
import com.atlassian.confluence.extra.calendar3.events.SubCalendarAddedSubscription;
import com.atlassian.confluence.extra.calendar3.events.SubCalendarCreatedOnJiraEventCreation;
import com.atlassian.confluence.extra.calendar3.events.SubCalendarInternalSubscribed;
import com.atlassian.confluence.extra.calendar3.exception.CalendarException;
import com.atlassian.confluence.extra.calendar3.model.EventTypeReminder;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubscribingSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.UserCalendarPreference;
import com.atlassian.confluence.extra.calendar3.model.rest.GeneralResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.AbstractSubCalendarResource;
import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import com.atlassian.confluence.extra.calendar3.rest.SubCalendarWatchingStatusEntity;
import com.atlassian.confluence.extra.calendar3.rest.SubCalendarsResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.SubscriptionCountResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.param.AddSubCalendarSubscriptionParam;
import com.atlassian.confluence.extra.calendar3.rest.param.DeleteSubCalendarParam;
import com.atlassian.confluence.extra.calendar3.rest.param.HideSubCalendarParam;
import com.atlassian.confluence.extra.calendar3.rest.param.RefreshSubCalendarParam;
import com.atlassian.confluence.extra.calendar3.rest.param.RestrictSubCalendarParam;
import com.atlassian.confluence.extra.calendar3.rest.param.UpdateCalendarParam;
import com.atlassian.confluence.extra.calendar3.rest.param.UpdateSubCalendarColorParam;
import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnlicensedSiteAccess
@Path(value="calendar")
@TeamCalResourceLogger
public class CalendarResource
extends AbstractSubCalendarResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarResource.class);
    private final CalendarManager calendarManager;
    private final CalendarPermissionManager calendarPermissionManager;
    private final SubCalendarSubscriptionStatisticsAccessor subCalendarSubscriptionStatisticsAccessor;
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;
    private final PrivateCalendarUrlManager privateCalendarUrlManager;
    private final EventPublisher eventPublisher;
    private final SpaceManager spaceManager;
    private final CalendarRenderer calendarRenderer;
    private final CalendarContentTypeManager calendarContentTypeManager;

    @Inject
    public CalendarResource(EventPublisher eventPublisher, @ComponentImport @Named(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, SubCalendarSubscriptionStatisticsAccessor subCalendarSubscriptionStatisticsAccessor, UserAccessor userAccessor, PrivateCalendarUrlManager privateCalendarUrlManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, SpaceManager spaceManager, CalendarRenderer calendarRenderer, CalendarContentTypeManager calendarContentTypeManager, @Named(value="cacheFactory") CacheFactory cacheFactory, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, globalSettingsManager, cacheFactory, txnTemplate);
        this.eventPublisher = eventPublisher;
        this.calendarManager = calendarManager;
        this.calendarPermissionManager = calendarPermissionManager;
        this.subCalendarSubscriptionStatisticsAccessor = subCalendarSubscriptionStatisticsAccessor;
        this.privateCalendarUrlManager = privateCalendarUrlManager;
        this.spacePermissionManager = spacePermissionManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.calendarRenderer = calendarRenderer;
        this.calendarContentTypeManager = calendarContentTypeManager;
    }

    @Path(value="subcalendars/user/view")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSubCalendarsInUserView() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return Response.ok((Object)this.calendarManager.getUserPreference(currentUser).getSubCalendarsInView()).build();
    }

    @Path(value="subcalendars/user/view")
    @PUT
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateSubCalendarsInUserView(String[] subCalendarIds) {
        return (Response)this.getTransactionTemplate().execute(() -> {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            Set finalSet = this.calendarManager.updateSubCalendarsInView(currentUser, subCalendarIds);
            return Response.ok((Object)finalSet).build();
        });
    }

    @AnonymousSiteAccess
    @Path(value="subcalendars/watching/status")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getWatchingStatus(@QueryParam(value="include") List<String> subCalendarIdIncludes) throws JSONException {
        try {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            HashSet<String> subCalendarIds = new HashSet<String>(null == subCalendarIdIncludes || subCalendarIdIncludes.isEmpty() ? this.calendarManager.getSubCalendarsInView(currentUser) : subCalendarIdIncludes);
            List persistedSubCalendars = this.calendarManager.getSubCalendarsWithRestriction(subCalendarIds.toArray(new String[0]));
            Map watchingCalendarStatuses = this.calendarManager.isWatching(currentUser, persistedSubCalendars.toArray(new PersistedSubCalendar[0]));
            ArrayList<SubCalendarWatchingStatusEntity> watchingStatuses = new ArrayList<SubCalendarWatchingStatusEntity>();
            for (PersistedSubCalendar subCalendar : persistedSubCalendars) {
                boolean isWatch = (Boolean)watchingCalendarStatuses.get(subCalendar.getId());
                boolean isWatchViaContent = this.calendarManager.isWatchingViaContent(subCalendar instanceof SubscribingSubCalendar ? this.calendarManager.getSubCalendar(((SubscribingSubCalendar)subCalendar).getSubscriptionId()) : subCalendar, currentUser);
                watchingStatuses.add(new SubCalendarWatchingStatusEntity(subCalendar, isWatch, isWatchViaContent));
            }
            JSONObject thisObj = new JSONObject();
            JSONArray subCalendarArray = new JSONArray();
            for (SubCalendarWatchingStatusEntity subCalendarWatchingStatusEntity : watchingStatuses) {
                subCalendarArray.put((Object)subCalendarWatchingStatusEntity.toJson());
            }
            thisObj.put("success", true);
            thisObj.put("payload", (Object)subCalendarArray);
            return Response.ok((Object)thisObj.toString()).build();
        }
        catch (Exception e) {
            return this.getResponseError(e, "Unable to get watching statuses", StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage());
        }
    }

    @AnonymousSiteAccess
    @Path(value="subcalendars")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSubCalendars(@QueryParam(value="include") List<String> subCalendarIdIncludes, @QueryParam(value="viewingSpaceKey") String viewingSpaceKey, @QueryParam(value="calendarContext") String calendarContext) {
        return this.getSubCalendarsResponse(calendarContext, viewingSpaceKey, subCalendarIdIncludes);
    }

    private Response getSubCalendarsResponse(String calendarContext, String spaceKey, List<String> subCalendarIdIncludes) {
        Collection<SubCalendarsResponseEntity.ExtendedSubCalendar> subCalendars = this.getSubcalendarsInternal(calendarContext, spaceKey, subCalendarIdIncludes);
        LOG.info("getSubCalendars successfully with total sub calendar is {}", (Object)(subCalendars == null ? 0 : subCalendars.size()));
        return Response.ok((Object)new SubCalendarsResponseEntity(new ArrayList<SubCalendarsResponseEntity.ExtendedSubCalendar>(subCalendars)).toJson().toString()).build();
    }

    @Path(value="subcalendars/preferences")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response hideSubCalendar(@BeanParam HideSubCalendarParam param) {
        return (Response)this.getTransactionTemplate().execute(() -> this.getHideSubCalendarResponse(param));
    }

    public Response getHideSubCalendarResponse(HideSubCalendarParam param) {
        String subCalendarId = param.getSubCalendarId();
        ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
        PersistedSubCalendar subCalendar = (PersistedSubCalendar)this.calendarManager.getPersistedSubCalendar(subCalendarId).orNull();
        if (subCalendar == null || !this.calendarPermissionManager.hasViewEventPrivilege(subCalendar, authenticatedUser)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.calendarnotfound")).toString()).build());
        }
        if (CalendarRenderer.CalendarContext.spaceCalendars.getValue().equals(param.getCalendarContext())) {
            if (!this.spacePermissionManager.hasPermission("VIEWSPACE", this.spaceManager.getSpace(param.getViewingSpaceKey()), authenticatedUser)) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
            }
            this.calendarManager.deleteSubCalendarOnSpace(subCalendar, param.getViewingSpaceKey());
        } else {
            this.calendarManager.hideSubCalendar(subCalendar, AuthenticatedUserThreadLocal.get());
        }
        return this.getSubCalendarsResponse(param.getCalendarContext(), param.getViewingSpaceKey(), null == param.getSubCalendarIds() ? Collections.emptyList() : new ArrayList(Collections2.filter(param.getSubCalendarIds(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)subCalendarId)))));
    }

    @Path(value="subcalendars/restrictions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response restrictSubCalendar(@BeanParam RestrictSubCalendarParam param) {
        return (Response)this.getTransactionTemplate().execute(() -> this.getRestrictSubCalendarResponse(param));
    }

    public Response getRestrictSubCalendarResponse(RestrictSubCalendarParam param) {
        Set<String> invalidGroupNames;
        List<String> groupsPermittedToEdit;
        Set<String> invalidUserIds;
        List<String> userIdsPermittedToEdit;
        Set<String> invalidGroupNames2;
        List<String> groupsPermittedToView;
        Set<String> invalidUsersIds;
        String subCalendarId = param.getSubCalendarId();
        if (!this.calendarManager.hasSubCalendar(StringUtils.defaultString((String)subCalendarId))) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (StringUtils.isNotBlank((CharSequence)subCalendarId) && (param.isUpdateUsersPermittedToView() || param.isUpdateGroupsPermittedToView() || param.isUpdateUsersPermittedToEdit() || param.isUpdateGroupsPermittedToEdit()) && !this.calendarPermissionManager.hasAdminSubCalendarPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        LinkedHashMap<String, List<String>> fieldErrors = new LinkedHashMap<String, List<String>>();
        List<String> userIdsPermittedToView = param.getUserIdsPermittedToView();
        if (null != userIdsPermittedToView && !(invalidUsersIds = this.getInvalidUserIds(userIdsPermittedToView)).isEmpty()) {
            this.addFieldError(fieldErrors, "permissions", this.getText("calendar3.error.invalidusernames", Arrays.asList(StringUtils.join(invalidUsersIds, (String)", "))));
        }
        if (null != (groupsPermittedToView = param.getGroupsPermittedToView()) && !(invalidGroupNames2 = this.getInvalidGroupNames(groupsPermittedToView)).isEmpty()) {
            this.addFieldError(fieldErrors, "permissions", this.getText("calendar3.error.invalidgroupnames", Arrays.asList(StringUtils.join(invalidGroupNames2, (String)", "))));
        }
        if (null != (userIdsPermittedToEdit = param.getUserIdsPermittedToEdit()) && !(invalidUserIds = this.getInvalidUserIds(userIdsPermittedToEdit)).isEmpty()) {
            this.addFieldError(fieldErrors, "permissions", this.getText("calendar3.error.invalidusernames", Arrays.asList(StringUtils.join(invalidUserIds, (String)", "))));
        }
        if (null != (groupsPermittedToEdit = param.getGroupsPermittedToEdit()) && !(invalidGroupNames = this.getInvalidGroupNames(groupsPermittedToEdit)).isEmpty()) {
            this.addFieldError(fieldErrors, "permissions", this.getText("calendar3.error.invalidgroupnames", Arrays.asList(StringUtils.join(invalidGroupNames, (String)", "))));
        }
        if (fieldErrors.isEmpty()) {
            if (param.isUpdateUsersPermittedToView()) {
                this.calendarPermissionManager.restrictEventViewToUsers(persistedSubCalendar, null == userIdsPermittedToView ? null : this.getIdsAsUsers(Sets.newHashSet(userIdsPermittedToView)));
            }
            if (param.isUpdateGroupsPermittedToView()) {
                this.calendarPermissionManager.restrictEventViewToGroups(persistedSubCalendar, (Set)(null == groupsPermittedToView ? null : new HashSet<String>(groupsPermittedToView)));
            }
            if (param.isUpdateUsersPermittedToEdit()) {
                this.calendarPermissionManager.restrictEventEditToUsers(persistedSubCalendar, null == userIdsPermittedToEdit ? null : this.getIdsAsUsers(Sets.newHashSet(userIdsPermittedToEdit)));
            }
            if (param.isUpdateGroupsPermittedToEdit()) {
                this.calendarPermissionManager.restrictEventEditToGroups(persistedSubCalendar, (Set)(null == groupsPermittedToEdit ? null : new HashSet<String>(groupsPermittedToEdit)));
            }
            return this.getSubCalendarsResponse(param.getCalendarContext(), param.getViewingSpaceKey(), param.getSubCalendarIncludes());
        }
        return this.createErrorResponse(fieldErrors);
    }

    @Path(value="subcalendars")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateSubCalendar(@BeanParam UpdateCalendarParam param) {
        return (Response)this.getTransactionTemplate().execute(() -> this.getUpdateSubCalendarResponse(param));
    }

    public Response getUpdateSubCalendarResponse(UpdateCalendarParam param) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        String subCalendarId = param.getSubCalendarId();
        Response response = this.updateSubCalendarInternal(StringUtils.isNotEmpty((CharSequence)param.getParentSubCalendarId()) ? this.calendarManager.getSubCalendar(param.getParentSubCalendarId()) : null, param.getType(), subCalendarId, param.getName(), param.getDescription(), param.getColor(), param.getSpaceKey(), param.getTimeZoneId(), param.getLocation(), param.getUserName(), param.getPassword(), StringUtils.isBlank((CharSequence)subCalendarId) && this.userAccessor.getUserPreferences(currentUser).isWatchingOwnContent(), param.getSubCalendarIncludes(), false, param.getCalendarContext(), param.getViewingSpaceKey());
        if (param.getType().equalsIgnoreCase("subscription")) {
            this.eventPublisher.publish((Object)new SubCalendarAddedSubscription(this, currentUser, StringUtils.isNotBlank((CharSequence)param.getSpaceKey())));
        } else {
            this.eventPublisher.publish((Object)new SubCalendarAddedNew(this, currentUser, StringUtils.isNotBlank((CharSequence)param.getSpaceKey())));
        }
        LOGGER.info("Calendar with name [{}[ for user [{}] has been create successfully", (Object)param.getName(), (Object)param.getUserName());
        return response;
    }

    private Response updateSubCalendarInternal(PersistedSubCalendar parentSubCalendar, String type, String subCalendarId, String name, String description, String color, String spaceKey, String timeZoneId, String location, String userName, String password, boolean addWatch, List<String> subCalendarIncludes, boolean isChangeColor, String calendarContext, String viewingSpaceKey) {
        LinkedHashMap<String, List<String>> fieldErrors = new LinkedHashMap<String, List<String>>();
        if (StringUtils.isNotBlank((CharSequence)subCalendarId) && !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        if (StringUtils.isBlank((CharSequence)color)) {
            color = this.calendarManager.getRandomCalendarColor(new String[0]);
        }
        if (null == this.calendarManager.getSubCalendarColorAsHexValue(StringUtils.defaultString((String)color))) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.invalidfield", Arrays.asList("color"))).toString()).build());
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        boolean isBadRequest = false;
        if (parentSubCalendar != null) {
            isBadRequest = !this.calendarPermissionManager.hasEditEventPrivilege(parentSubCalendar, confluenceUser);
        } else if (!StringUtils.isBlank((CharSequence)subCalendarId)) {
            boolean bl = isBadRequest = !this.calendarPermissionManager.hasAdminSubCalendarPrivilege(this.calendarManager.getSubCalendar(subCalendarId), confluenceUser);
        }
        if (!this.calendarPermissionManager.hasEditSubCalendarPrivilege(confluenceUser) || isBadRequest) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            this.addFieldError(fieldErrors, "name", this.getText("calendar3.error.blank"));
        }
        try {
            String eventType;
            PersistedSubCalendar sourceSubCalendar;
            SubCalendar subCalendar;
            Object object = subCalendar = StringUtils.isBlank((CharSequence)subCalendarId) ? new SubCalendar() : (PersistedSubCalendar)this.calendarManager.getSubCalendar(subCalendarId).clone();
            if (!isChangeColor && subCalendar instanceof InternalSubscriptionCalendarDataStore.InternalSubscriptionSubCalendar && CalendarUtil.isJiraSubCalendarType((sourceSubCalendar = ((InternalSubscriptionCalendarDataStore.InternalSubscriptionSubCalendar)subCalendar).getSourceSubCalendar()).getType())) {
                subCalendar = sourceSubCalendar;
                parentSubCalendar = ((InternalSubscriptionCalendarDataStore.InternalSubscriptionSubCalendar)parentSubCalendar).getSourceSubCalendar();
            }
            subCalendar.setType(type);
            subCalendar.setParent(parentSubCalendar);
            subCalendar.setSpaceKey(spaceKey);
            subCalendar.setName(name);
            subCalendar.setDescription(description);
            subCalendar.setColor(color);
            subCalendar.setTimeZoneId(timeZoneId);
            subCalendar.setSourceLocation(StringUtils.trim((String)location));
            subCalendar.setUserName(userName);
            subCalendar.setPassword(password);
            this.calendarManager.validateSubCalendar(subCalendar, fieldErrors);
            if (!fieldErrors.isEmpty()) {
                return this.createErrorResponse(fieldErrors);
            }
            PersistedSubCalendar updatedSubCalendar = this.calendarManager.save(subCalendar);
            this.calendarManager.unhideEventsOfSubCalendar(updatedSubCalendar, confluenceUser);
            if (addWatch && updatedSubCalendar.isWatchable()) {
                this.calendarManager.watchSubCalendar(updatedSubCalendar, confluenceUser);
            }
            if (StringUtils.isNotBlank((CharSequence)(eventType = CalendarUtil.getEventTypeFromStoreKey(updatedSubCalendar.getStoreKey()))) && CalendarUtil.isJiraEventType(eventType) && this.hasPeriodReminderForEvent(parentSubCalendar, eventType)) {
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                this.eventPublisher.publish((Object)new SubCalendarCreatedOnJiraEventCreation((Object)updatedSubCalendar, currentUser, parentSubCalendar));
            }
            JSONObject responseJson = new SubCalendarsResponseEntity(new ArrayList<SubCalendarsResponseEntity.ExtendedSubCalendar>(this.getSubcalendarsInternal(calendarContext, viewingSpaceKey, subCalendarIncludes)), updatedSubCalendar.getId()).toJson();
            return Response.ok((Object)responseJson.toString()).build();
        }
        catch (UnsupportedOperationException e) {
            this.addFieldError(fieldErrors, "location", this.getText("calendar3.error.unsupportedsubcalendarlocation"));
            return this.createErrorResponse(fieldErrors);
        }
        catch (CalendarException e) {
            return this.getResponseError(e, String.format("Unable to save/update sub-calendar %s", name), this.getText(e.getErrorMessageKey(), e.getErrorMessageSubstitutions()));
        }
        catch (Exception e) {
            return this.getResponseError(e, String.format("Unable to save/update sub-calendar %s", name), StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage());
        }
    }

    private boolean hasPeriodReminderForEvent(PersistedSubCalendar parentSubCalendar, String eventType) {
        Set eventTypeReminders = parentSubCalendar.getEventTypeReminders();
        for (EventTypeReminder eventTypeReminder : eventTypeReminders) {
            if (!eventTypeReminder.getEventTypeId().equals(eventType)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getInvalidGroupNames(Collection<String> groupNames) {
        return new HashSet<String>(Collections2.filter(groupNames, groupName -> null == this.userAccessor.getGroup(groupName)));
    }

    private Set<String> getInvalidUserIds(Collection<String> userIds) {
        return Sets.newHashSet((Iterable)Collections2.filter(userIds, userId -> this.getUserById((String)userId) == null));
    }

    private void addFieldError(Map<String, List<String>> fieldErrors, String field, String msg) {
        List<String> errorMessages;
        if (fieldErrors.containsKey(field)) {
            errorMessages = fieldErrors.get(field);
        } else {
            errorMessages = new ArrayList<String>();
            fieldErrors.put(field, errorMessages);
        }
        msg = HtmlUtil.htmlEncode((String)msg);
        if (!errorMessages.contains(msg)) {
            errorMessages.add(msg);
        }
    }

    @Path(value="subcalendars")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteSubCalendar(@BeanParam DeleteSubCalendarParam param) {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (persistedSubCalendar instanceof SubscribingSubCalendar ? !this.calendarPermissionManager.hasEditSubCalendarPrivilege(AuthenticatedUserThreadLocal.get()) : !this.calendarPermissionManager.hasDeleteSubCalendarPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            this.calendarManager.removeSubCalendar(persistedSubCalendar);
            return this.getSubCalendarsResponse(param.getCalendarContext(), param.getViewingSpaceKey(), param.getSubCalendarIdIncludes());
        });
    }

    @Path(value="subcalendars/color")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateSubCalendarColor(@BeanParam UpdateSubCalendarColorParam param) {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            PersistedSubCalendar subCalendar = this.calendarManager.getSubCalendar(subCalendarId);
            return this.updateSubCalendarInternal(subCalendar.getParent(), subCalendar.getType(), subCalendarId, subCalendar.getName(), subCalendar.getDescription(), param.getColor(), subCalendar.getSpaceKey(), subCalendar.getTimeZoneId(), subCalendar.getSourceLocation(), subCalendar.getUserName(), subCalendar.getPassword(), false, param.getSubCalendarIncludes(), true, param.getCalendarContext(), param.getViewingSpaceKey());
        });
    }

    @Path(value="subcalendar/space")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateCalendarSpace(UpdateCalendarSpaceParam param) {
        String subCalendarId = param.getCalendarId();
        String spaceKey = param.getSpaceKey();
        Optional persistedSubCalendar = this.calendarManager.getPersistedSubCalendar(subCalendarId);
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !persistedSubCalendar.isPresent()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.calendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            PersistedSubCalendar subCalendar = (PersistedSubCalendar)persistedSubCalendar.get();
            return this.updateSubCalendarInternal(subCalendar.getParent(), subCalendar.getType(), subCalendarId, subCalendar.getName(), subCalendar.getDescription(), subCalendar.getColor(), spaceKey, subCalendar.getTimeZoneId(), subCalendar.getSourceLocation(), subCalendar.getUserName(), subCalendar.getPassword(), false, Arrays.asList(subCalendarId), true, null, null);
        });
    }

    @AnonymousSiteAccess
    @PUT
    @Path(value="subcalendars/admin/refresh")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response refreshSubCalendar(@BeanParam RefreshSubCalendarParam param) {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            PersistedSubCalendar subCalendar = this.calendarManager.getSubCalendar(subCalendarId);
            if (!this.calendarPermissionManager.hasReloadEventsPrivilege(subCalendar, AuthenticatedUserThreadLocal.get())) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
            }
            this.calendarManager.refresh(subCalendar);
            return Response.ok((Object)new GeneralResponseEntity().toJson().toString()).build();
        });
    }

    @Path(value="subcalendar/privateurl/{subCalendarId}")
    @GET
    @Produces(value={"text/text"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response privateUrlForCalendar(@PathParam(value="subCalendarId") String subCalendarId) {
        PersistedSubCalendar subCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (subCalendar == null || !this.calendarPermissionManager.hasViewEventPrivilege(subCalendar, AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String token = this.privateCalendarUrlManager.getTokenFor(AuthenticatedUserThreadLocal.get(), subCalendarId);
        if (token == null) {
            LOG.error("Unable to generate private token for sub-calendar {}", (Object)subCalendarId);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)(this.globalSettingsManager.getGlobalSettings().getBaseUrl() + "/rest/calendar-services/1.0/calendar/export/subcalendar/private/" + token + ".ics")).build();
    }

    @Path(value="/subcalendar/privateurl/reset/{subCalendarId}")
    @PUT
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response resetPrivateUrls(@PathParam(value="subCalendarId") String subCalendarId) {
        return (Response)this.getTransactionTemplate().execute(() -> {
            this.privateCalendarUrlManager.resetPrivateUrlsFor(AuthenticatedUserThreadLocal.get(), subCalendarId);
            return Response.ok().build();
        });
    }

    @Path(value="/subcalendar/privateurl/resetall")
    @PUT
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response resetAllPrivateUrls() {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            this.privateCalendarUrlManager.resetAllPrivateUrls();
            return Response.ok().build();
        });
    }

    @Path(value="haspopular")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response hasPopularSubCalendarSubscriptions() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean hasPopular = this.subCalendarSubscriptionStatisticsAccessor.hasPopularSubscriptions(currentUser);
        return Response.ok((Object)hasPopular).build();
    }

    @Path(value="subcalendars/subscribe")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response addSubCalendarSubscription(@BeanParam AddSubCalendarSubscriptionParam param) {
        return (Response)this.getTransactionTemplate().execute(() -> this.getAddSubCalendarSubscriptionResponse(param));
    }

    public Response getAddSubCalendarSubscriptionResponse(AddSubCalendarSubscriptionParam param) {
        List<String> subCalendarIds = param.getSubCalendarIds();
        if (null != subCalendarIds) {
            ArrayList<String> subCalendarColors = new ArrayList<String>(this.calendarManager.getAvailableSubCalendarColorCssClasses());
            String currentColor = param.getColor();
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            boolean onSpace = CalendarRenderer.CalendarContext.spaceCalendars.getValue().equals(param.getCalendarContext());
            Collection subCalendarIdsInView = Collections2.filter((Collection)Collections2.transform((Collection)(onSpace ? this.calendarManager.getSubCalendarsOnSpace(param.getViewingSpaceKey()) : this.calendarManager.getSubCalendarsInView(AuthenticatedUserThreadLocal.get())), subCalendarId -> {
                PersistedSubCalendar subCalendarInView = this.calendarManager.getSubCalendar(subCalendarId);
                if (null == subCalendarInView) {
                    return null;
                }
                return subCalendarInView instanceof SubscribingSubCalendar ? ((SubscribingSubCalendar)subCalendarInView).getSubscriptionId() : subCalendarInView.getId();
            }), (Predicate)Predicates.notNull());
            for (PersistedSubCalendar toSubscribe : Collections2.filter((Collection)Collections2.transform(subCalendarIds, arg_0 -> ((CalendarManager)this.calendarManager).getSubCalendar(arg_0)), (Predicate)Predicates.and((Predicate)Predicates.notNull(), persistedSubCalendar -> !subCalendarIdsInView.contains(persistedSubCalendar.getId()) && this.calendarPermissionManager.hasViewEventPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())))) {
                if (StringUtils.equals((CharSequence)toSubscribe.getCreator(), (CharSequence)currentUser.getKey().toString()) && !onSpace) {
                    HashSet<String> subCalendarsInView = new HashSet<String>(this.calendarManager.getSubCalendarsInView(currentUser));
                    subCalendarsInView.add(toSubscribe.getId());
                    UserCalendarPreference userCalendarPreference = this.calendarManager.getUserPreference(currentUser);
                    userCalendarPreference.setSubCalendarsInView(subCalendarsInView);
                    this.calendarManager.setUserPreference(currentUser, userCalendarPreference);
                    if (param.isAddWatch()) {
                        this.calendarManager.watchSubCalendar(toSubscribe, currentUser);
                    }
                } else {
                    String spaceKeySubscribe = null;
                    if (StringUtils.isNotEmpty((CharSequence)toSubscribe.getSpaceKey()) && this.spaceManager.getSpace(toSubscribe.getSpaceKey()) != null) {
                        spaceKeySubscribe = toSubscribe.getSpaceKey();
                    }
                    this.updateSubCalendarInternal(null, "internal-subscription", null, toSubscribe.getName(), toSubscribe.getDescription(), currentColor, onSpace ? param.getViewingSpaceKey() : spaceKeySubscribe, null, "subscription://" + toSubscribe.getId(), null, null, param.isAddWatch(), Collections.emptyList(), false, param.getCalendarContext(), param.getViewingSpaceKey());
                }
                currentColor = this.getNextSubCalendarColor(currentColor, subCalendarColors);
                this.eventPublisher.publish((Object)new SubCalendarInternalSubscribed(toSubscribe, currentUser, onSpace));
            }
        }
        return this.getSubCalendarsResponse(param.getCalendarContext(), param.getViewingSpaceKey(), param.getSubCalendarIncludes());
    }

    @Path(value="subcalendars/links")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getContentLinkingToSpaceSubCalendar(@QueryParam(value="subCalendarId") String subCalendarId) {
        return Response.ok((Object)new SubscriptionCountResponseEntity(!this.calendarManager.hasSubCalendar(subCalendarId) ? 0 : this.subCalendarSubscriptionStatisticsAccessor.getSubscriberCount(this.calendarManager.getSubCalendar(subCalendarId))).toJson().toString()).build();
    }

    @Path(value="render")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getCalendarRenderHTML(@QueryParam(value="calendarContext") CalendarRenderer.CalendarContext calendarContext) {
        Map calendarParams = this.calendarRenderer.newRenderParamsBuilder().calendarContext(calendarContext).build();
        return Response.ok((Object)this.calendarRenderer.render(calendarParams)).build();
    }

    @Path(value="render/space")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSpaceCalendarRenderHTML(@QueryParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("spaceKey", spaceKey);
        Map calendarParams = this.calendarRenderer.newRenderParamsBuilder().calendarContext(CalendarRenderer.CalendarContext.spaceCalendars).build();
        long numberOfCalendars = this.calendarManager.countSubCalendarsOnSpace(spaceKey);
        response.put("numberOfCalendars", numberOfCalendars);
        response.put("licenseMessages", calendarParams.get(CalendarRenderer.RenderParamsBuilder.ParamName.licenseMessages));
        CustomContentEntityObject cceo = this.calendarContentTypeManager.loadCalendarContentBySpaceKey(spaceKey);
        if (cceo == null) {
            this.calendarContentTypeManager.createCalendarContentTypeFor(space);
            cceo = this.calendarContentTypeManager.loadCalendarContentBySpaceKey(space.getKey());
        }
        calendarParams.put(CalendarRenderer.RenderParamsBuilder.ParamName.contentId, cceo.getIdAsString());
        calendarParams.put(CalendarRenderer.RenderParamsBuilder.ParamName.enableShareCalendar, false);
        response.put("html", this.calendarRenderer.render(calendarParams));
        return Response.ok(response).build();
    }

    public static class UpdateCalendarSpaceParam {
        @XmlElement
        String calendarId;
        @XmlElement
        String spaceKey;

        public String getCalendarId() {
            return this.calendarId;
        }

        public void setCalendarId(String calendarId) {
            this.calendarId = calendarId;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }
    }
}

