/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.CalendarSettingsManager;
import com.atlassian.confluence.extra.calendar3.GenericMessage;
import com.atlassian.confluence.extra.calendar3.calendarstore.InternalSubscriptionCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.exception.RuntimeCredentialsRequiredException;
import com.atlassian.confluence.extra.calendar3.model.ConfluenceUserInvitee;
import com.atlassian.confluence.extra.calendar3.model.CustomEventType;
import com.atlassian.confluence.extra.calendar3.model.EventTypeReminder;
import com.atlassian.confluence.extra.calendar3.model.LocalizedSubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.model.SubscribingSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.rest.GeneralResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.AbstractResource;
import com.atlassian.confluence.extra.calendar3.rest.AbstractSubCalendarResource;
import com.atlassian.confluence.extra.calendar3.rest.EventResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.EventResponseWarningEntity;
import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import com.atlassian.confluence.extra.calendar3.rest.LoadEventsOverOauthRequiredEntity;
import com.atlassian.confluence.extra.calendar3.rest.SubCalendarsResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.param.DeleteEventParam;
import com.atlassian.confluence.extra.calendar3.rest.param.UpdateEventParam;
import com.atlassian.confluence.extra.calendar3.rest.resources.MessageToStringTransformerFunction;
import com.atlassian.confluence.extra.calendar3.rest.statemachine.EventUpdateStateMachine;
import com.atlassian.confluence.extra.calendar3.rest.statemachine.StateHandler;
import com.atlassian.confluence.extra.calendar3.rest.statemachine.StateHandlerList;
import com.atlassian.confluence.extra.calendar3.rest.statemachine.UpdateEventContext;
import com.atlassian.confluence.extra.calendar3.rest.validators.event.EventChainValidator;
import com.atlassian.confluence.extra.calendar3.util.TimeZoneUtil;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="calendar/events")
@TeamCalResourceLogger
public class EventResource
extends AbstractSubCalendarResource {
    private static final int MAX_USERS = 3;
    private final CalendarSettingsManager teamCalendarSettingsManager;
    private final FormatSettingsManager formatSettingsManager;
    private final EventChainValidator eventChainValidator;
    private final List<StateHandler> stateHandlers;
    private final TransactionTemplate transactionTemplate;

    @Inject
    protected EventResource(I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, CalendarSettingsManager teamCalendarSettingsManager, UserAccessor userAccessor, @ComponentImport @Named(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, FormatSettingsManager formatSettingsManager, EventChainValidator eventValidator, StateHandlerList stateHandlerList, @Named(value="cacheFactory") CacheFactory cacheFactory, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, globalSettingsManager, cacheFactory, txnTemplate);
        this.teamCalendarSettingsManager = teamCalendarSettingsManager;
        this.formatSettingsManager = formatSettingsManager;
        this.eventChainValidator = eventValidator;
        this.stateHandlers = stateHandlerList.getStateHandlers();
        this.transactionTemplate = txnTemplate;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateEvent(@BeanParam UpdateEventParam param) throws Exception {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                DateTime start;
                LinkedHashMap<String, List<String>> fieldErrors = new LinkedHashMap<String, List<String>>();
                this.eventChainValidator.isValid(param, fieldErrors);
                if (!fieldErrors.isEmpty()) {
                    return this.createErrorResponse(fieldErrors);
                }
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                String subCalendarId = param.getSubCalendarId();
                String originalSubCalendarId = param.getOriginalSubCalendarId();
                String eventType = param.getEventType();
                String uid = param.getUid();
                String what = param.getWhat();
                String originalEventType = param.getOriginalEventType();
                String customEventTypeId = param.getCustomEventTypeId();
                List<String> person = param.getPerson();
                String url = param.getUrl();
                boolean allDayEvent = param.isAllDayEvent();
                String freq = param.getFreq();
                String interval = param.getInterval();
                String until = param.getUntil();
                String userTimeZoneId = param.getUserTimeZoneId();
                DateTimeZone userTimeZone = DateTimeZone.forID((String)userTimeZoneId);
                boolean dragAndDropUpdate = param.isDragAndDropUpdate();
                DateTime dateTime = dragAndDropUpdate ? ISODateTimeFormat.dateTimeParser().withZone(userTimeZone).parseDateTime(param.getStartDateDnd()) : (start = TimeZoneUtil.tryParseDateTimeStringForEventEdit(this.localeManager, param.getStartDate(), allDayEvent ? null : param.getStartTime(), userTimeZone));
                DateTime end = dragAndDropUpdate ? ISODateTimeFormat.dateTimeParser().withZone(userTimeZone).parseDateTime(param.getEndDateDnd()) : TimeZoneUtil.tryParseDateTimeStringForEventEdit(this.localeManager, param.getEndDate(), allDayEvent ? null : param.getEndTime(), userTimeZone);
                end = allDayEvent ? end.plusDays(1) : end;
                String repeatUntilString = null;
                if (StringUtils.isNotBlank((CharSequence)until)) {
                    LocalDate localDate = TimeZoneUtil.tryParseISODateStringForEventEdit(until);
                    Objects.requireNonNull(localDate);
                    repeatUntilString = allDayEvent ? localDate.toString(ISODateTimeFormat.basicDate()) : new DateTime(start.withDate(localDate).getMillis(), DateTimeZone.UTC).toString(ISODateTimeFormat.basicDateTimeNoMillis());
                }
                SubCalendarEvent subCalendarEvent = new SubCalendarEvent();
                subCalendarEvent.setEditAllInRecurrenceSeries(param.isEditAllInRecurrenceSeries());
                if (StringUtils.isNotBlank((CharSequence)uid)) {
                    subCalendarEvent.setUid(this.getUnwrappedEventUid(uid));
                }
                if (StringUtils.isNotBlank((CharSequence)param.getOriginalStartDate())) {
                    subCalendarEvent.setOriginalStart(param.getOriginalStartDate());
                }
                subCalendarEvent.setName(what);
                subCalendarEvent.setInvitees(Optional.ofNullable(person).orElse(Collections.emptyList()).stream().map(confluenceUserId -> new ConfluenceUserInvitee(this.getUserById((String)confluenceUserId))).collect(Collectors.toSet()));
                subCalendarEvent.setUrl(StringUtils.trim((String)url));
                subCalendarEvent.setDescription(StringUtils.defaultString((String)param.getDescription()));
                subCalendarEvent.setLocation(StringUtils.defaultString((String)param.getWhere()));
                subCalendarEvent.setStartTime(start);
                subCalendarEvent.setEndTime(end);
                subCalendarEvent.setRecurrenceId((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)param.getRecurrenceId()), null));
                subCalendarEvent.setAllDay(allDayEvent);
                subCalendarEvent.setEventType(eventType);
                subCalendarEvent.setCustomEventTypeId(param.getCustomEventTypeId());
                subCalendarEvent.setOriginalCustomEventTypeId(param.getOriginalCustomEventTypeId());
                if (param.isEditAllInRecurrenceSeries() || StringUtils.isBlank((CharSequence)subCalendarEvent.getRecurrenceId())) {
                    if (StringUtils.isNotBlank((CharSequence)param.getRruleStr())) {
                        if (StringUtils.isNotBlank((CharSequence)repeatUntilString)) {
                            if (param.getRruleStr().contains("UNTIL")) {
                                throw new RuntimeException(String.format("RRule string %s sent is incorrect", param.getRruleStr()));
                            }
                            String newRruleString = param.getRruleStr() + ";UNTIL=" + repeatUntilString;
                            subCalendarEvent.setRruleStr(newRruleString);
                        } else {
                            subCalendarEvent.setRruleStr(param.getRruleStr());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)freq)) {
                        subCalendarEvent.setRepeat(new SubCalendarEvent.Repeat((String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)freq), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)param.getByDay()), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)interval), null), repeatUntilString));
                    }
                }
                UpdateEventContext context = new UpdateEventContext(originalSubCalendarId, subCalendarId, subCalendarEvent, param);
                EventUpdateStateMachine<UpdateEventContext> stateMachine = new EventUpdateStateMachine<UpdateEventContext>(context);
                stateMachine.registerHandler(this.stateHandlers);
                stateMachine.start(EventUpdateStateMachine.States.START);
                if (StringUtils.isBlank((CharSequence)subCalendarEvent.getUid())) {
                    stateMachine.trigger(EventUpdateStateMachine.Events.create);
                } else {
                    stateMachine.trigger(EventUpdateStateMachine.Events.update);
                }
                SubCalendarEvent updatedEvent = context.getUpdatedEvent();
                this.calendarManager.unhideEventsOfSubCalendar(updatedEvent.getSubCalendar(), currentUser);
                PersistedSubCalendar subCalendar = updatedEvent.getSubCalendar();
                PersistedSubCalendar parentSubCalendar = subCalendar.getParent();
                boolean isTurnOnReminder = false;
                if (parentSubCalendar != null) {
                    if (StringUtils.isNotEmpty((CharSequence)customEventTypeId) && !parentSubCalendar.getCustomEventTypes().isEmpty()) {
                        Set customEventTypes = parentSubCalendar.getCustomEventTypes();
                        for (CustomEventType customEventType : customEventTypes) {
                            if (!customEventType.getCustomEventTypeId().equals(customEventTypeId) || customEventType.getPeriodInMins() <= 0) continue;
                            isTurnOnReminder = true;
                            break;
                        }
                    } else if (StringUtils.isEmpty((CharSequence)customEventTypeId) && !parentSubCalendar.getEventTypeReminders().isEmpty()) {
                        Set eventTypeReminders = parentSubCalendar.getEventTypeReminders();
                        for (EventTypeReminder eventTypeReminder : eventTypeReminders) {
                            if (!eventTypeReminder.getEventTypeId().equals(eventType)) continue;
                            isTurnOnReminder = true;
                            break;
                        }
                    }
                }
                return Response.ok((Object)new EventResponseEntity((SubCalendarEvent)new LocalizedSubCalendarEvent(updatedEvent, userTimeZone, this.getUserLocale(), this.formatSettingsManager, this.teamCalendarSettingsManager), new SubCalendarsResponseEntity.ExtendedSubCalendar(subCalendar, this.calendarPermissionManager.hasViewEventPrivilege(subCalendar, currentUser), this.calendarPermissionManager.hasReloadEventsPrivilege(subCalendar, currentUser), this.calendarPermissionManager.hasEditSubCalendarPrivilege(currentUser), this.calendarPermissionManager.hasEditEventPrivilege(subCalendar, currentUser), false, false, false, 0, false, this.calendarManager.isEventsOfSubCalendarHidden(subCalendar, currentUser), this.calendarPermissionManager.hasDeleteSubCalendarPrivilege(subCalendar, currentUser), this.calendarPermissionManager.hasAdminSubCalendarPrivilege(subCalendar, currentUser), new HashSet<SubCalendarsResponseEntity.ExtendedSubCalendar.PermittedUser>(Collections2.transform((Collection)this.calendarPermissionManager.getEventViewUserRestrictions(subCalendar), (Function)new AbstractResource.UserToPermittedUserTransformer(this.userAccessor, this.globalSettingsManager, this.cacheFactory))), this.calendarPermissionManager.getEventViewGroupRestrictions(subCalendar), new HashSet<SubCalendarsResponseEntity.ExtendedSubCalendar.PermittedUser>(Collections2.transform((Collection)this.calendarPermissionManager.getEventEditUserRestrictions(subCalendar), (Function)new AbstractResource.UserToPermittedUserTransformer(this.userAccessor, this.globalSettingsManager, this.cacheFactory))), this.calendarPermissionManager.getEventEditGroupRestrictions(subCalendar), Collections.emptySet(), isTurnOnReminder)).toJson().toString()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteEvent(@BeanParam DeleteEventParam param) throws Exception {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                Set disableEventTypes;
                String subCalendarId = param.getSubCalendarId();
                if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
                }
                boolean hasEditEventPrivilege = this.calendarPermissionManager.hasEditEventPrivilege(this.calendarManager.getSubCalendar(subCalendarId), AuthenticatedUserThreadLocal.get());
                if (!hasEditEventPrivilege) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
                }
                PersistedSubCalendar subCalendar = this.calendarManager.getSubCalendar(subCalendarId);
                if (subCalendar.getParent() != null && (disableEventTypes = subCalendar.getParent().getDisableEventTypes()) != null) {
                    boolean isDisableEventType = false;
                    if (this.isSubscribingSubCalendar(subCalendar)) {
                        String subscriptionType = ((SubscribingSubCalendar)subCalendar).getSubscriptionType();
                        if (subscriptionType.equals("custom")) {
                            Set customEventTypeSet = subCalendar.getCustomEventTypes();
                            if (customEventTypeSet != null && !customEventTypeSet.isEmpty() && disableEventTypes.contains(((CustomEventType)customEventTypeSet.iterator().next()).getCustomEventTypeId())) {
                                isDisableEventType = true;
                            }
                        } else if (disableEventTypes.contains(subscriptionType)) {
                            isDisableEventType = true;
                        }
                    } else if (disableEventTypes.contains(subCalendar.getType())) {
                        isDisableEventType = true;
                    }
                    if (isDisableEventType) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.disableEvent.permission.deleteevent", Arrays.asList(subCalendar.getName()))).toString()).build());
                    }
                }
                String uid = param.getUid();
                String recurUntil = param.getRecurUntil();
                if (StringUtils.isNotBlank((CharSequence)recurUntil)) {
                    this.calendarManager.stopEventRecurrence(this.calendarManager.getSubCalendar(subCalendarId), this.getUnwrappedEventUid(uid), recurUntil);
                } else {
                    String originalStart = param.getOriginalStart();
                    String recurrenceId = param.getRecurrenceId();
                    if (StringUtils.isBlank((CharSequence)originalStart) || StringUtils.isNotBlank((CharSequence)recurrenceId)) {
                        this.calendarManager.removeEvent(this.calendarManager.getSubCalendar(subCalendarId), this.getUnwrappedEventUid(uid), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.trim((String)recurrenceId), null));
                    } else {
                        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
                        this.calendarManager.excludeEvent(persistedSubCalendar, this.getUnwrappedEventUid(uid), ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).parseDateTime(originalStart));
                    }
                }
                return Response.ok((Object)new GeneralResponseEntity().toJson().toString()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @AnonymousSiteAccess
    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getEvents(@QueryParam(value="subCalendarId") String subCalendarId, @QueryParam(value="userTimeZoneId") String userTimeZoneId, @QueryParam(value="start") String start, @QueryParam(value="end") String end) throws Exception {
        ConfluenceUser currentUser;
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.loadevents.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        PersistedSubCalendar subCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (!this.calendarPermissionManager.hasViewEventPrivilege(subCalendar, currentUser = AuthenticatedUserThreadLocal.get())) {
            String warningMessage = this.getPermissionsWarning(subCalendar);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray("warning-type", warningMessage).toString()).build());
        }
        try {
            DateTimeZone userTimeZone = DateTimeZone.forID((String)userTimeZoneId);
            Collection subCalendarEvents = Collections2.transform((Collection)this.calendarManager.getEvents(subCalendar, ISODateTimeFormat.dateTimeParser().parseDateTime(start), ISODateTimeFormat.dateTimeParser().parseDateTime(end).plusDays(30)), (Function)Functions.compose((Function)new LocalizedSubCalendarEventTransformer(userTimeZone, this.getUserLocale(), this.formatSettingsManager, this.teamCalendarSettingsManager), subCalendarEvent -> {
                if (null != subCalendarEvent.getOriginalStartTime()) {
                    subCalendarEvent.setUid(this.getWrappedEventUid((SubCalendarEvent)subCalendarEvent));
                }
                return subCalendarEvent;
            }));
            String warning = null;
            Message messageWarning = this.calendarManager.getSubCalendarEventWarning(subCalendar, ISODateTimeFormat.dateTimeParser().parseDateTime(start).getMillis(), ISODateTimeFormat.dateTimeParser().parseDateTime(end).plusDays(30).getMillis());
            if (messageWarning != null) {
                warning = new MessageToStringTransformerFunction(this.getI18nBean()).apply(messageWarning);
            }
            return Response.ok((Object)new EventResponseWarningEntity(warning, subCalendarEvents).toJson().toString()).build();
        }
        catch (CredentialsRequiredException e) {
            return this.handleApplinkCredential(subCalendarId, subCalendar, e);
        }
        catch (Exception e) {
            CacheException cacheException;
            Throwable innerException;
            if (e instanceof CacheException && (innerException = (cacheException = (CacheException)e).getCause()) instanceof RuntimeCredentialsRequiredException) {
                CredentialsRequiredException credentialsRequiredException = ((RuntimeCredentialsRequiredException)innerException).getCredentialsRequiredException();
                this.handleApplinkCredential(subCalendarId, subCalendar, credentialsRequiredException);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to load events of sub-calendar {}", (Object)subCalendarId, (Object)e);
            } else {
                LOG.error("Unable to load events of sub-calendar {}", (Object)subCalendarId);
            }
            Response errorResponse = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.loadevents.unexpected", Arrays.asList(subCalendar.getName(), subCalendarId, StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage()))).toString()).build();
            throw new WebApplicationException(errorResponse);
        }
    }

    private Response handleApplinkCredential(@QueryParam(value="subCalendarId") String subCalendarId, PersistedSubCalendar subCalendar, CredentialsRequiredException e) {
        LOG.info("Unable to retrieve JIRA sub-calendar {} events. User is probably not authenticated. Log at DEBUG level for more details.", (Object)subCalendarId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to retrieve JIRA sub-calendar {} events.", (Object)subCalendarId, (Object)e);
        } else {
            LOG.error("Unable to retrieve JIRA sub-calendar {} events.", (Object)subCalendarId);
        }
        String oAuthUriString = e.getAuthorisationURI().toString();
        Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)String.format("OAuth realm=\"%s\"", oAuthUriString)).entity((Object)new LoadEventsOverOauthRequiredEntity(oAuthUriString, subCalendar.getId(), subCalendar.getName())).build();
        throw new WebApplicationException(response);
    }

    @Path(value="upcoming/{status}")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response setUpcommingEventEnable(@PathParam(value="status") String status) {
        boolean isShowUpcommingBadge = Boolean.parseBoolean((String)StringUtils.defaultIfEmpty((CharSequence)status, (CharSequence)"false"));
        this.teamCalendarSettingsManager.setShowUpcommingEventBadge(isShowUpcommingBadge);
        return Response.ok().build();
    }

    @AnonymousSiteAccess
    @Path(value="{viewingSpaceKey}/upcoming")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSubCalendars(@PathParam(value="viewingSpaceKey") String viewingSpaceKey, @QueryParam(value="calendarContext") String calendarContext, @QueryParam(value="userTimeZoneId") String userTimeZoneId, @QueryParam(value="start") String start, @QueryParam(value="end") String end) throws JSONException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        DateTimeZone userTimeZone = DateTimeZone.forID((String)userTimeZoneId);
        DateTime startDate = new DateTime((Object)start).withZone(DateTimeZone.forOffsetHours((int)0)).withZoneRetainFields(userTimeZone);
        DateTime endDate = new DateTime((Object)end).withZone(DateTimeZone.forOffsetHours((int)0)).withZoneRetainFields(userTimeZone);
        if (!this.teamCalendarSettingsManager.isShowUpcommingEventBadge()) {
            return Response.ok((Object)this.getUpcommingJsonObject(0, 0).toString()).build();
        }
        Collection<SubCalendarsResponseEntity.ExtendedSubCalendar> subCalendars = this.getSubcalendarsInternal(calendarContext, viewingSpaceKey, null);
        if (subCalendars.size() > 5) {
            return Response.ok((Object)this.getUpcommingJsonObject(subCalendars.size(), 0).toString()).build();
        }
        int sumEvents = 0;
        for (SubCalendarsResponseEntity.ExtendedSubCalendar subCalendar : subCalendars) {
            Set childSubCalendarIds = subCalendar.getSubCalendar().getChildSubCalendarIds();
            for (String subCalendarId : childSubCalendarIds) {
                PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
                if (!this.calendarPermissionManager.hasViewEventPrivilege(persistedSubCalendar, currentUser)) continue;
                try {
                    Set upcomingEvents = this.calendarManager.getUpcomingEvents(persistedSubCalendar, startDate, endDate);
                    sumEvents += upcomingEvents.size();
                }
                catch (Exception e) {
                    LOG.debug("Unable to get events for subCalendarId: {}", (Object)subCalendarId, (Object)e);
                }
            }
        }
        JSONObject upComingEventsJson = this.getUpcommingJsonObject(subCalendars.size(), sumEvents);
        return Response.ok((Object)upComingEventsJson.toString()).build();
    }

    private String getPermissionsWarning(PersistedSubCalendar subCalendar) {
        String warningMessage;
        Set<ConfluenceUser> editors = new HashSet();
        String contactAdminUrl = this.globalSettingsManager.getGlobalSettings().getBaseUrl() + "/contactadministrators.action";
        if (subCalendar instanceof InternalSubscriptionCalendarDataStore.InternalSubscriptionSubCalendar) {
            PersistedSubCalendar parentSubCalendar = ((InternalSubscriptionCalendarDataStore.InternalSubscriptionSubCalendar)subCalendar).getSourceSubCalendar().getParent();
            editors = this.calendarPermissionManager.getEventEditUserRestrictions(parentSubCalendar);
            ConfluenceUser creatorUser = this.userAccessor.getUserByKey(new UserKey(parentSubCalendar.getCreator()));
            if (creatorUser != null) {
                editors.add(creatorUser);
            }
        }
        if (!editors.isEmpty()) {
            ArrayList<String> userNames = new ArrayList<String>();
            for (ConfluenceUser user : editors) {
                userNames.add(StringEscapeUtils.escapeHtml4((String)user.getFullName()));
                if (userNames.size() <= 3) continue;
                break;
            }
            GenericMessage message = new GenericMessage("calendar3.error.loadevents.notpermission.contactUserEdit", new Serializable[]{StringEscapeUtils.escapeHtml4((String)subCalendar.getName()), StringUtils.join(userNames, (String)", "), contactAdminUrl});
            warningMessage = this.getWarningMessages(subCalendar, message);
        } else {
            GenericMessage message = new GenericMessage("calendar3.error.loadevents.notpermission", new Serializable[]{StringEscapeUtils.escapeHtml4((String)subCalendar.getName()), contactAdminUrl});
            warningMessage = this.getWarningMessages(subCalendar, message);
        }
        return warningMessage;
    }

    private String getWarningMessages(PersistedSubCalendar subCalendar, Message message) {
        return new MessageToStringTransformerFunction(this.getI18nBean()).apply(this.calendarManager.getTextForSubCalendar(subCalendar, message));
    }

    private JSONObject getUpcommingJsonObject(int numnberOfCalendar, int sumEvents) throws JSONException {
        JSONObject upComingEventsJson = new JSONObject();
        upComingEventsJson.put("upcomingEvents", sumEvents);
        upComingEventsJson.put("subCalendars", numnberOfCalendar);
        return upComingEventsJson;
    }

    private String getUnwrappedEventUid(String wrappedEventUid) {
        int indexOfSlash = StringUtils.indexOf((CharSequence)wrappedEventUid, (int)47);
        if (0 <= indexOfSlash && indexOfSlash < wrappedEventUid.length() - 1) {
            return wrappedEventUid.substring(indexOfSlash + 1);
        }
        return wrappedEventUid;
    }

    private String getWrappedEventUid(SubCalendarEvent sce) {
        return sce.getOriginalStart() + '/' + sce.getUid();
    }

    private boolean isSubscribingSubCalendar(PersistedSubCalendar persistedSubCalendar) {
        return persistedSubCalendar instanceof SubscribingSubCalendar;
    }

    private static class LocalizedSubCalendarEventTransformer
    implements Function<SubCalendarEvent, LocalizedSubCalendarEvent> {
        private final DateTimeZone userTimeZone;
        private final Locale userLocale;
        private final FormatSettingsManager formatSettingsManager;
        private final CalendarSettingsManager calendarSettingsManager;

        private LocalizedSubCalendarEventTransformer(DateTimeZone userTimeZone, Locale userLocale, FormatSettingsManager formatSettingsManager, CalendarSettingsManager calendarSettingsManager) {
            this.userTimeZone = userTimeZone;
            this.userLocale = userLocale;
            this.formatSettingsManager = formatSettingsManager;
            this.calendarSettingsManager = calendarSettingsManager;
        }

        public LocalizedSubCalendarEvent apply(SubCalendarEvent subCalendarEvent) {
            return new LocalizedSubCalendarEvent(subCalendarEvent, this.userTimeZone, this.userLocale, this.formatSettingsManager, this.calendarSettingsManager);
        }
    }
}

