/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.model.CustomEventType;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.rest.GeneralResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.AbstractSubCalendarResource;
import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import com.atlassian.confluence.extra.calendar3.rest.SubCalendarsResponseEntity;
import com.atlassian.confluence.extra.calendar3.rest.param.DeleteCustomEventTypeParam;
import com.atlassian.confluence.extra.calendar3.rest.param.DisableEventTypeParam;
import com.atlassian.confluence.extra.calendar3.rest.param.UpdateCustomEventTypeParam;
import com.atlassian.confluence.extra.calendar3.rest.param.UpdateSandBoxEventTypeParam;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;

@Path(value="calendar/eventtype")
@TeamCalResourceLogger
public class EventTypeResource
extends AbstractSubCalendarResource {
    @Inject
    protected EventTypeResource(I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, UserAccessor userAccessor, @ComponentImport @Named(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @Named(value="cacheFactory") CacheFactory cacheFactory, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, globalSettingsManager, cacheFactory, txnTemplate);
    }

    @Path(value="sandbox")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateSanboxEventType(@BeanParam UpdateSandBoxEventTypeParam param) {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        String title = param.getTitle();
        if (StringUtils.isBlank((CharSequence)title) || title.length() > 256) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar.customeventtype.error.title")).toString()).build());
        }
        if (StringUtils.isBlank((CharSequence)param.getIcon())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.missing.icon")).toString()).build());
        }
        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (persistedSubCalendar == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        if (!this.calendarPermissionManager.hasEditEventPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            try {
                this.calendarManager.updateReminderForSanboxEventType(persistedSubCalendar, param.getEventTypeId(), param.getPeriodInMins());
                return Response.ok((Object)new GeneralResponseEntity().toJson().toString()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Path(value="custom")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateCustomEventType(@BeanParam UpdateCustomEventTypeParam param) throws Exception {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        String title = param.getTitle();
        if (StringUtils.isBlank((CharSequence)title) || title.length() > 256) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar.customeventtype.error.title")).toString()).build());
        }
        if (StringUtils.isBlank((CharSequence)param.getIcon())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.missing.icon")).toString()).build());
        }
        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (persistedSubCalendar == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        if (!this.calendarPermissionManager.hasEditEventPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            try {
                return this.updateCustomEventType(persistedSubCalendar, param.getCustomEventTypeId(), title, param.getIcon(), param.getPeriodInMins());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Path(value="custom")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteCustomEventType(@BeanParam DeleteCustomEventTypeParam param) {
        Optional persistedSubCalendar;
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId) || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            this.throwNotFoundWebApplicationException(subCalendarId);
        }
        if (!(persistedSubCalendar = this.calendarManager.getPersistedSubCalendar(subCalendarId)).isPresent()) {
            this.throwNotFoundWebApplicationException(subCalendarId);
        }
        if (!this.calendarPermissionManager.hasEditEventPrivilege((PersistedSubCalendar)persistedSubCalendar.get(), AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        String customEventTypeId = param.getCustomEventTypeId();
        if (StringUtils.isBlank((CharSequence)customEventTypeId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.customeventypenotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            try {
                this.calendarManager.deleteCustomEventType(subCalendarId, customEventTypeId);
                return Response.ok((Object)new GeneralResponseEntity().toJson().toString()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Path(value="disable")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response disableEventTypeCalendar(@BeanParam DisableEventTypeParam param) {
        String subCalendarId = param.getSubCalendarId();
        if (StringUtils.isBlank((CharSequence)subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        PersistedSubCalendar persistedSubCalendar = this.calendarManager.getSubCalendar(subCalendarId);
        if (persistedSubCalendar == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        if (!this.calendarPermissionManager.hasEditEventPrivilege(persistedSubCalendar, AuthenticatedUserThreadLocal.get())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.notpermitted")).toString()).build());
        }
        return (Response)this.getTransactionTemplate().execute(() -> {
            try {
                return this.disableEventTypes(persistedSubCalendar, param.getDisableEventTypes());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Response updateCustomEventType(PersistedSubCalendar persistedSubCalendar, String customEventTypeId, String title, String icon, int periodInMins) throws Exception {
        LOG.info("Updating custom event type for Calendar {}", (Object)persistedSubCalendar.getName());
        CustomEventType customEventType = this.calendarManager.updateCustomEventType(persistedSubCalendar, customEventTypeId, title, icon, periodInMins);
        return Response.status((Response.Status)Response.Status.OK).header("Content-Type", (Object)"application/json").entity((Object)customEventType.toJson().toString()).build();
    }

    private Response disableEventTypes(PersistedSubCalendar persistedSubCalendar, List<String> disableEventTypes) {
        try {
            this.calendarManager.disableEventTypes(persistedSubCalendar, disableEventTypes);
            String persistedSubCalendarId = persistedSubCalendar.getId();
            JSONObject responseJson = new SubCalendarsResponseEntity(new ArrayList<SubCalendarsResponseEntity.ExtendedSubCalendar>(this.getSubcalendarsInternal(null, null, new ArrayList<String>(Arrays.asList(persistedSubCalendarId)))), persistedSubCalendarId).toJson();
            return Response.ok((Object)responseJson.toString()).build();
        }
        catch (Exception e) {
            return this.getResponseError(e, "Unable to disable event for Calendar " + persistedSubCalendar.getName(), StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage());
        }
    }

    private void throwNotFoundWebApplicationException(String subCalendarId) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
    }
}

