/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.CalendarSettingsManager;
import com.atlassian.confluence.extra.calendar3.ICalendarExporter;
import com.atlassian.confluence.extra.calendar3.PrivateCalendarUrlManager;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.rest.AbstractResource;
import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Path(value="calendar/export")
@TeamCalResourceLogger
public class ExportResource
extends AbstractResource {
    private final ICalendarExporter iCalendarExporter;
    private final CalendarSettingsManager teamCalendarSettingsManager;
    private final PrivateCalendarUrlManager privateCalendarUrlManager;

    @Inject
    protected ExportResource(I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, UserAccessor userAccessor, ICalendarExporter iCalendarExporter, CalendarSettingsManager teamCalendarSettingsManager, PrivateCalendarUrlManager privateCalendarUrlManager, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, txnTemplate);
        this.iCalendarExporter = iCalendarExporter;
        this.teamCalendarSettingsManager = teamCalendarSettingsManager;
        this.privateCalendarUrlManager = privateCalendarUrlManager;
    }

    @Path(value="subcalendar/{subCalendarId}.ics")
    @GET
    @Produces(value={"text/calendar; charset=UTF-8"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response exportCalendarAsIcalendarText(@PathParam(value="subCalendarId") String subCalendarId, @QueryParam(value="isSubscribe") @DefaultValue(value="true") boolean isSubscribe) {
        return this.exportCalendarAsIcalendarTextInternal(AuthenticatedUserThreadLocal.get(), subCalendarId, false, isSubscribe);
    }

    @Path(value="subcalendar/private/{subCalendarToken}.ics")
    @GET
    @Produces(value={"text/calendar; charset=UTF-8"})
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"READ"})
    public Response exportPrivateCalendarAsIcalendarText(@PathParam(value="subCalendarToken") String subCalendarToken) {
        if (!this.teamCalendarSettingsManager.arePrivateUrlsEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ConfluenceUser user = this.privateCalendarUrlManager.getUserFor(subCalendarToken);
        String subCalendarId = this.privateCalendarUrlManager.getCalendarId(subCalendarToken);
        if (subCalendarId == null) {
            LOG.info("No calendar found for private token: {}. The user may have reset their private URL.", (Object)subCalendarToken);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (user == null) {
            LOG.warn("No user associated with calendar: {} for private token: {}", (Object)subCalendarId, (Object)subCalendarToken);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Optional optionalPersistedSubCalendar = this.calendarManager.getPersistedSubCalendar(subCalendarId);
        if (!optionalPersistedSubCalendar.isPresent()) {
            LOG.warn("Calendar not found for calendar id: {} for private token: {}", (Object)subCalendarId, (Object)subCalendarToken);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.calendarPermissionManager.hasViewEventPrivilege((PersistedSubCalendar)optionalPersistedSubCalendar.get(), user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.exportCalendarAsIcalendarTextInternal(user, subCalendarId, true, true);
    }

    private Response exportCalendarAsIcalendarTextInternal(ConfluenceUser forUser, String subCalendarId, boolean allowAnonymousAccess, boolean isSubscribe) {
        if (subCalendarId == null || !this.calendarManager.hasSubCalendar(subCalendarId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(this.getText("calendar3.error.subcalendarnotfound", Arrays.asList(subCalendarId))).toString()).build());
        }
        PersistedSubCalendar subCalendar = (PersistedSubCalendar)this.calendarManager.getPersistedSubCalendar(subCalendarId).orNull();
        if (null == subCalendar || !allowAnonymousAccess && !this.calendarPermissionManager.hasViewEventPrivilege(subCalendar, AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            return Response.ok(outputStream -> {
                try {
                    this.iCalendarExporter.export(forUser, subCalendar, outputStream, isSubscribe);
                }
                catch (Exception exportError) {
                    throw new WebApplicationException((Throwable)exportError);
                }
            }).build();
        }
        catch (Exception e) {
            return this.getResponseError(e, String.format("Unable to export sub-calendar %s", subCalendarId), StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage());
        }
    }
}

