/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.CalendarPermissionManager;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.rest.AbstractResource;
import com.atlassian.confluence.extra.calendar3.rest.Interceptors.TeamCalResourceLogger;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="calendar/util")
@TeamCalResourceLogger
public class UtilityResource
extends AbstractResource {
    private final CalendarManager calendarManager;

    @Inject
    public UtilityResource(I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, CalendarManager calendarManager, CalendarPermissionManager calendarPermissionManager, UserAccessor userAccessor, @ComponentImport TransactionTemplate txnTemplate) {
        super(i18NBeanFactory, localeManager, calendarManager, calendarPermissionManager, userAccessor, txnTemplate);
        this.calendarManager = calendarManager;
    }

    @Path(value="format/subcalendar/ids")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSubCalendarsMapFromCommaSeparatedIds(@QueryParam(value="subCalendarIds") String subCalendarIds) {
        JSONArray subCalendarsJsonArray = new JSONArray();
        try {
            for (String subCalendarId : new HashSet<String>(Arrays.asList(StringUtils.split((String)StringUtils.defaultString((String)subCalendarIds), (String)", ")))) {
                PersistedSubCalendar subCalendar = (PersistedSubCalendar)this.calendarManager.getPersistedSubCalendar(subCalendarId).orNull();
                if (null == subCalendar) continue;
                JSONObject subCalendarJson = new JSONObject();
                subCalendarJson.put("id", (Object)subCalendar.getId());
                subCalendarJson.put("name", (Object)subCalendar.getName());
                subCalendarsJsonArray.put((Object)subCalendarJson);
            }
            return Response.ok((Object)subCalendarsJsonArray.toString()).build();
        }
        catch (JSONException e) {
            LOG.error("Unable to translate sub calendar IDs {}", (Object)subCalendarIds, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Content-Type", (Object)"application/json").entity((Object)this.toJsonArray(StringUtils.isBlank((CharSequence)e.getMessage()) ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage()).toString()).build());
        }
    }

    @Path(value="validate/group")
    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response filterInvalidGroupNames(@QueryParam(value="groupNames") List<String> groupNames) {
        Collection validGroupNames = Collections2.filter(groupNames, (Predicate)Predicates.and((Predicate)Predicates.notNull(), groupName -> null != this.userAccessor.getGroup(groupName)));
        return Response.ok().entity((Object)this.toJsonArray(validGroupNames.toArray(new String[validGroupNames.size()])).toString()).build();
    }
}

