/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.validators.event.impl;

import com.atlassian.confluence.extra.calendar3.rest.param.UpdateEventParam;
import com.atlassian.confluence.extra.calendar3.rest.validators.event.AbstractEventValidator;
import com.atlassian.confluence.extra.calendar3.util.TimeZoneUtil;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UntilFieldValidator
extends AbstractEventValidator {
    @Autowired
    public UntilFieldValidator(@ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory) {
        super(localeManager, i18NBeanFactory);
    }

    @Override
    public boolean isValid(UpdateEventParam param, Map<String, List<String>> fieldErrors) throws WebApplicationException {
        String userTimeZoneId = param.getUserTimeZoneId();
        DateTimeZone userTimeZone = DateTimeZone.forID((String)userTimeZoneId);
        String uid = param.getUid();
        boolean dragAndDropUpdate = param.isDragAndDropUpdate();
        boolean allDayEvent = param.isAllDayEvent();
        if (StringUtils.isNotBlank((CharSequence)param.getUntil())) {
            DateTime start = dragAndDropUpdate ? ISODateTimeFormat.dateTimeParser().withZone(userTimeZone).parseDateTime(param.getStartDateDnd()) : TimeZoneUtil.tryParseDateTimeStringForEventEdit(this.localeManager, param.getStartDate(), allDayEvent ? null : param.getStartTime(), userTimeZone);
            LocalDate repeatUntil = TimeZoneUtil.tryParseISODateStringForEventEdit(param.getUntil());
            if (null == repeatUntil) {
                this.addFieldError(fieldErrors, "until", this.getText("calendar3.error.invalid.date"));
            } else if ((param.isEditAllInRecurrenceSeries() || StringUtils.isBlank((CharSequence)uid)) && repeatUntil.isBefore((ReadablePartial)start.toLocalDate())) {
                this.addFieldError(fieldErrors, "until", this.getText("calendar3.error.repeatendsbeforestart"));
            }
        }
        return true;
    }
}

