/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.rest.validators.event.impl;

import com.atlassian.confluence.extra.calendar3.rest.param.UpdateEventParam;
import com.atlassian.confluence.extra.calendar3.rest.validators.event.AbstractEventValidator;
import com.atlassian.confluence.extra.calendar3.util.TimeZoneUtil;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.ws.rs.WebApplicationException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenFieldValidator
extends AbstractEventValidator {
    @Autowired
    public WhenFieldValidator(@ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory) {
        super(localeManager, i18NBeanFactory);
    }

    @Override
    public boolean isValid(UpdateEventParam param, Map<String, List<String>> fieldErrors) throws WebApplicationException {
        DateTime end;
        DateTime start;
        String userTimeZoneId = param.getUserTimeZoneId();
        DateTimeZone userTimeZone = DateTimeZone.forID((String)userTimeZoneId);
        DateTime now = new DateTime(userTimeZone);
        boolean dragAndDropUpdate = param.isDragAndDropUpdate();
        boolean allDayEvent = param.isAllDayEvent();
        DateTime dateTime = dragAndDropUpdate ? ISODateTimeFormat.dateTimeParser().withZone(userTimeZone).parseDateTime(param.getStartDateDnd()) : (start = TimeZoneUtil.tryParseDateTimeStringForEventEdit(this.localeManager, param.getStartDate(), allDayEvent ? null : param.getStartTime(), userTimeZone));
        if (start == null) {
            this.addFieldError(fieldErrors, "when", this.getText(allDayEvent ? "calendar3.error.invalid.date" : "calendar3.error.invalid.date.time"));
        }
        DateTime dateTime2 = dragAndDropUpdate ? ISODateTimeFormat.dateTimeParser().withZone(userTimeZone).parseDateTime(param.getEndDateDnd()) : (end = TimeZoneUtil.tryParseDateTimeStringForEventEdit(this.localeManager, param.getEndDate(), allDayEvent ? null : param.getEndTime(), userTimeZone));
        if (end == null && !param.isSingleJiraDate()) {
            this.addFieldError(fieldErrors, "when", this.getText(allDayEvent ? "calendar3.error.invalid.date" : "calendar3.error.invalid.date.time"));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getUntil())) {
            LocalDate untilDate = TimeZoneUtil.tryParseISODateStringForEventEdit(param.getUntil());
            if (untilDate == null) {
                this.addFieldError(fieldErrors, "until", this.getText("calendar3.error.invalid.date"));
            } else if (start != null && untilDate.isBefore((ReadablePartial)start.toLocalDate())) {
                this.addFieldError(fieldErrors, "until", this.getText("calendar3.error.repeatendsbeforestart", Arrays.asList(TimeZoneUtil.getDateFormatter(this.localeManager, userTimeZone).print((ReadableInstant)now), TimeZoneUtil.getTimeFormatter(this.localeManager, userTimeZone, "HH:mm").print((ReadableInstant)now))));
            }
        }
        if (start == null || end == null || param.isSingleJiraDate()) {
            return true;
        }
        if (allDayEvent && start.isAfter((ReadableInstant)end)) {
            this.addFieldError(fieldErrors, "when", this.getText("calendar3.error.startafterend"));
        } else if (!allDayEvent && (start.isAfter((ReadableInstant)end) || start.isEqual((ReadableInstant)end))) {
            this.addFieldError(fieldErrors, "when", this.getText("calendar3.error.startafterorequalend"));
        }
        return true;
    }
}

