/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.servlet;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarSummary;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.Collections2;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class CalendarMacroImagePlaceholderGeneratorServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarMacroImagePlaceholderGeneratorServlet.class);
    private final CalendarManager calendarManager;
    private final LocaleManager localeManager;

    public CalendarMacroImagePlaceholderGeneratorServlet(CalendarManager calendarManager, LocaleManager localeManager) {
        this.calendarManager = calendarManager;
        this.localeManager = localeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String methodSignature = "doGet(HttpServletRequest req, HttpServletResponse resp)";
        UtilTimerStack.push((String)methodSignature);
        try {
            String redirectUrl = String.format("%s/plugins/servlet/confluence/placeholder/macro?definition=%s&locale=%s&version=2&view=%s", req.getContextPath(), Base64.encodeBase64URLSafeString((byte[])this.getMacroDefinition(req).getBytes(StandardCharsets.UTF_8)), HtmlUtil.urlEncode((String)this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()).toString()), HtmlUtil.urlEncode((String)req.getParameter("defaultView")));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirecting to {}", (Object)redirectUrl);
            }
            resp.sendRedirect(redirectUrl);
        }
        finally {
            UtilTimerStack.pop((String)methodSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMacroDefinition(HttpServletRequest req) {
        String methodSignature = "getMacroDefinition(HttpServletRequest req)";
        UtilTimerStack.push((String)methodSignature);
        try {
            String subCalendarIds = req.getParameter("subCalendarIds");
            LinkedHashSet subCalendarNames = new LinkedHashSet();
            if (StringUtils.isNotBlank((CharSequence)subCalendarIds)) {
                subCalendarNames.addAll(Collections2.transform(Arrays.asList(StringUtils.split((String)subCalendarIds, (String)",")), subCalendarId -> {
                    SubCalendarSummary subCalendarSummary = this.calendarManager.getSubCalendarSummary(subCalendarId);
                    return null == subCalendarSummary ? subCalendarId : subCalendarSummary.getName();
                }));
            }
            StringBuilder macroDefinitionBuilder = new StringBuilder("{calendar");
            if (!subCalendarNames.isEmpty()) {
                macroDefinitionBuilder.append(":").append(StringUtils.join(subCalendarNames, (String)", "));
            }
            String string = macroDefinitionBuilder.append("}").toString();
            return string;
        }
        finally {
            UtilTimerStack.pop((String)methodSignature);
        }
    }
}

