/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.servlet;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.confluence.extra.calendar3.util.BuildInformationManager;
import com.atlassian.webresource.api.WebResourceManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;

@SystemAdminOnly
public class PostInstallDialogInjectFilter
implements Filter {
    private final WebResourceManager webResourceManager;
    private final BuildInformationManager buildInformationManager;
    private String postInstallDialogResourceKey;
    private String upmLicensePromptResourcesKey;

    public PostInstallDialogInjectFilter(WebResourceManager webResourceManager, BuildInformationManager buildInformationManager) {
        this.webResourceManager = webResourceManager;
        this.buildInformationManager = buildInformationManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.postInstallDialogResourceKey = this.buildInformationManager.getPluginKey() + ":post-install-dialog-resources";
        this.upmLicensePromptResourcesKey = this.buildInformationManager.getPluginKey() + ":upm-license-prompt-resources";
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.webResourceManager.requireResource(this.postInstallDialogResourceKey);
        if (BooleanUtils.toBoolean((String)servletRequest.getParameter("unlicensed"))) {
            this.webResourceManager.requireResource(this.upmLicensePromptResourcesKey);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

