/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.regex.Pattern;

@UnrestrictedAccess
public class TeamCalendarAuthTypeFilter
implements Filter {
    private static final Pattern PRIVATE_CALENDAR_EXPORT_PATTERN = Pattern.compile("/rest/calendar-services/1\\.0/calendar/export/subcalendar/private/[^.]{1,1000}\\.ics");
    private static final String OS_AUTH_TYPE_DEFAULT_ATTR = "os_authTypeDefault";
    private static final String AUTH_TYPE_NONE = "none";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (TeamCalendarAuthTypeFilter.isPrivateCalendarExportRequest(httpRequest)) {
            httpRequest.setAttribute(OS_AUTH_TYPE_DEFAULT_ATTR, (Object)AUTH_TYPE_NONE);
        }
        chain.doFilter(request, response);
    }

    private static boolean isPrivateCalendarExportRequest(HttpServletRequest request) {
        String pathInfo;
        if (request == null) {
            return false;
        }
        String servletPath = request.getServletPath();
        String fullPath = (servletPath != null ? servletPath : "") + ((pathInfo = request.getPathInfo()) != null ? pathInfo : "");
        if (fullPath.isEmpty()) {
            return false;
        }
        return PRIVATE_CALENDAR_EXPORT_PATTERN.matcher(fullPath).matches();
    }

    public void destroy() {
    }
}

