/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.upgrade.task;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.calendar3.DefaultPrivateCalendarUrlManager;
import com.atlassian.confluence.extra.calendar3.util.BuildInformationManager;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.core.util.PairType;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class BandanaRemovalUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private final BandanaManager bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final BuildInformationManager buildInformationManager;
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();

    @Autowired
    public BandanaRemovalUpgradeTask(@ComponentImport BandanaManager bandanaManager, @ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory, BuildInformationManager buildInformationManager) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.buildInformationManager = buildInformationManager;
    }

    public int getBuildNumber() {
        return 1400000000;
    }

    public String getShortDescription() {
        return "Migrate Bandana URL token mappings to Plugin Settings";
    }

    public Collection<Message> doUpgrade() {
        log.info("Migrating Bandana records for URL token mappings");
        Iterable tokenMapKeys = this.bandanaManager.getKeys((BandanaContext)new NoParentBandanaContext(DefaultPrivateCalendarUrlManager.TOKEN_MAP_NAMESPACE));
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(DefaultPrivateCalendarUrlManager.TOKEN_MAP_NAMESPACE);
        for (String key : tokenMapKeys) {
            Object bandanaValue = this.bandanaManager.getValue((BandanaContext)new NoParentBandanaContext(DefaultPrivateCalendarUrlManager.TOKEN_MAP_NAMESPACE), key);
            if (bandanaValue instanceof PairType) {
                PairType pair = (PairType)bandanaValue;
                try {
                    pluginSettings.put(key, (Object)this.mapper.writeValueAsString((Object)pair));
                }
                catch (JsonProcessingException e) {
                    log.error("Failed to serialize pair for key {}", (Object)key, (Object)e);
                    continue;
                }
                log.info("Migrated Bandana record for key: {}", (Object)key);
                continue;
            }
            log.warn("Unexpected value type for key {}: {}", (Object)key, bandanaValue);
        }
        log.info("Migrating Bandana records for URL token mappings completed");
        return List.of();
    }

    public String getPluginKey() {
        return this.buildInformationManager.getPluginKey();
    }
}

