/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.util;

import com.atlassian.confluence.extra.calendar3.JodaIcal4jDateTimeConverter;
import com.atlassian.confluence.extra.calendar3.JodaIcal4jTimeZoneMapper;
import net.fortuna.ical4j.extensions.property.WrCalDesc;
import net.fortuna.ical4j.extensions.property.WrCalName;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarImportUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarImportUtil.class);
    private final JodaIcal4jTimeZoneMapper jodaIcal4jTimeZoneMapper;
    private final JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter;

    @Autowired
    public CalendarImportUtil(JodaIcal4jTimeZoneMapper jodaIcal4jTimeZoneMapper, JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter) {
        this.jodaIcal4jTimeZoneMapper = jodaIcal4jTimeZoneMapper;
        this.jodaIcal4jDateTimeConverter = jodaIcal4jDateTimeConverter;
    }

    public String getTimeZoneFromCalendar(Calendar calendar) {
        Property xWrTimeZone;
        String timeZoneId = null;
        VTimeZone vTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
        if (vTimeZone != null) {
            timeZoneId = vTimeZone.getTimeZoneId().getValue();
        }
        if (timeZoneId == null && null != (xWrTimeZone = calendar.getProperty("X-WR-TIMEZONE"))) {
            timeZoneId = xWrTimeZone.getValue();
        }
        if (timeZoneId == null) {
            timeZoneId = this.jodaIcal4jTimeZoneMapper.getSystemTimeZoneIdJoda(true);
        }
        return timeZoneId;
    }

    public Calendar normalize(Calendar subCalendarData, String timeZoneId, String name, String description) {
        ComponentList subCalendarDataComponents = subCalendarData.getComponents();
        PropertyList subCalendarDataProperties = subCalendarData.getProperties();
        TimeZone subCalendarTimeZone = this.jodaIcal4jTimeZoneMapper.getIcal4jTimeZone(timeZoneId);
        VTimeZone timeZoneComponent = subCalendarTimeZone.getVTimeZone();
        subCalendarDataComponents.remove((Object)subCalendarDataComponents.getComponent("VTIMEZONE"));
        subCalendarDataComponents.add((Object)timeZoneComponent);
        subCalendarDataProperties.remove((Property)subCalendarDataProperties.getProperty("X-WR-TIMEZONE"));
        subCalendarDataProperties.add((Property)new XProperty("X-WR-TIMEZONE", new ParameterList(), timeZoneComponent.getTimeZoneId().getValue()));
        subCalendarDataProperties.remove((Property)subCalendarDataProperties.getProperty("X-WR-CALNAME"));
        subCalendarDataProperties.add((Property)new WrCalName(new ParameterList(), name));
        subCalendarDataProperties.remove((Property)subCalendarDataProperties.getProperty("X-WR-CALDESC"));
        subCalendarDataProperties.add((Property)new WrCalDesc(new ParameterList(), StringUtils.defaultString((String)description).replaceAll("((\\r\\n)|\\r|\\n)", "\\n")));
        ComponentList eventComponents = subCalendarDataComponents.getComponents("VEVENT");
        DateTimeZone subCalendarTimeZoneJoda = this.jodaIcal4jTimeZoneMapper.toJodaTimeZone(subCalendarTimeZone.getID());
        for (VEvent eventComponent : eventComponents) {
            DtStart dateStartProperty = eventComponent.getStartDate();
            DtEnd dateEndProperty = eventComponent.getEndDate();
            if (dateEndProperty == null) {
                dateEndProperty = new DtEnd(dateStartProperty.getDate());
            }
            if (!(dateStartProperty.getDate() instanceof DateTime) || !(dateEndProperty.getDate() instanceof DateTime)) continue;
            PropertyList eventPropertyList = eventComponent.getProperties();
            eventPropertyList.remove((Property)dateStartProperty);
            DateTime startDate = (DateTime)dateStartProperty.getDate();
            this.SanitizeEventTimeZone(subCalendarTimeZoneJoda, eventComponent, startDate);
            eventPropertyList.add((Property)new DtStart((Date)this.jodaIcal4jDateTimeConverter.toIcal4jDateTime(this.jodaIcal4jDateTimeConverter.toJodaTime((Date)startDate, null == startDate.getTimeZone() ? subCalendarTimeZone : startDate.getTimeZone()).withZone(subCalendarTimeZoneJoda))));
            eventPropertyList.remove((Property)dateEndProperty);
            DateTime endDate = (DateTime)dateEndProperty.getDate();
            this.SanitizeEventTimeZone(subCalendarTimeZoneJoda, eventComponent, endDate);
            eventPropertyList.add((Property)new DtEnd((Date)this.jodaIcal4jDateTimeConverter.toIcal4jDateTime(this.jodaIcal4jDateTimeConverter.toJodaTime((Date)endDate, null == endDate.getTimeZone() ? subCalendarTimeZone : endDate.getTimeZone()).withZone(subCalendarTimeZoneJoda))));
        }
        return subCalendarData;
    }

    private void SanitizeEventTimeZone(DateTimeZone subCalendarTimeZoneJoda, VEvent eventComponent, DateTime dateTime) {
        block4: {
            if (dateTime.getTimeZone() == null) {
                dateTime.setTimeZone(this.jodaIcal4jTimeZoneMapper.toIcal4jTimeZone(subCalendarTimeZoneJoda.getID()));
            }
            if (!this.jodaIcal4jTimeZoneMapper.isTimeZoneSupported(dateTime.getTimeZone())) {
                try {
                    TimeZone timeZone = this.jodaIcal4jTimeZoneMapper.getIcal4jTimeZone(dateTime.getTimeZone().getID());
                    dateTime.setTimeZone(timeZone);
                }
                catch (NullPointerException e) {
                    if (subCalendarTimeZoneJoda == null) break block4;
                    LOG.warn("Unknown timezone: {} for event {}. Event timezone set to: {}", new Object[]{dateTime.getTimeZone().getID(), eventComponent.getSummary(), subCalendarTimeZoneJoda.getID()});
                    dateTime.setTimeZone(this.jodaIcal4jTimeZoneMapper.toIcal4jTimeZone(subCalendarTimeZoneJoda.getID()));
                }
            }
        }
    }
}

