/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.util;

import com.atlassian.confluence.extra.calendar3.JodaIcal4jTimeZoneMapper;
import com.atlassian.confluence.setup.BuildInformation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Url;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class CalendarUtil {
    private static final String JIRA_ISSUE_EVENT_TYPE = "jira-calendar";
    private static final String JIRA_PROJECT_EVENT_TYPE = "jira-project-releases-calendar";
    private static final String JIRA_AGILE_SPRINT_EVENT_TYPE = "jira-agile-sprint-calendar";
    private static final Pattern VERSION_EVENT_PATTERN = Pattern.compile("^.*fixforversion/\\d+$");
    public static final Pattern BASE_URL_REPLACE_FOR_BROWSE = Pattern.compile("^http.+/browse/");
    public static final int MAX_JIRA_ISSUES_TO_DISPLAY = Integer.getInteger("com.atlassian.confluence.extra.calendar3.jira.issues.max", 1000);

    public static String getImageExtensionFromMineType(String mineType) {
        HashMap<String, String> mineTypeToExtensionMap = new HashMap<String, String>();
        mineTypeToExtensionMap.put("image/jpeg", "jpg");
        mineTypeToExtensionMap.put("image/png", "png");
        mineTypeToExtensionMap.put("image/gif", "gif");
        return mineTypeToExtensionMap.getOrDefault(mineType, "png");
    }

    public static String limitByWord(String inputText, int numberOfWord) {
        if (StringUtils.isEmpty((CharSequence)inputText)) {
            return inputText;
        }
        List<String> words = Arrays.asList(inputText.split(" "));
        return words.stream().limit(numberOfWord).collect(Collectors.joining(" "));
    }

    public static boolean isJiraSubCalendarType(String subCalendarType) {
        String[] jiraTypes = new String[]{"jira", "jira-project-releases", "jira-agile-sprint"};
        return Arrays.asList(jiraTypes).contains(subCalendarType);
    }

    public static String convertSubCalendarTypeToJiraEventType(String subCalendarType) {
        return switch (subCalendarType) {
            case "jira" -> JIRA_ISSUE_EVENT_TYPE;
            case "jira-project-releases" -> JIRA_PROJECT_EVENT_TYPE;
            case "jira-agile-sprint" -> JIRA_AGILE_SPRINT_EVENT_TYPE;
            default -> subCalendarType;
        };
    }

    public static String getEventTypeFromStoreKey(String storeKey) {
        String eventType = "";
        if (StringUtils.isEmpty((CharSequence)storeKey)) {
            return eventType;
        }
        eventType = switch (storeKey) {
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.GenericLocalSubCalendarDataStore" -> "other";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.BirthdaySubCalendarDataStore" -> "birthdays";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.LeaveSubCalendarDataStore" -> "leaves";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.TravelSubCalendarDataStore" -> "travel";
            case "JIRA_ISSUE_DATES_SUB_CALENDAR_STORE" -> JIRA_ISSUE_EVENT_TYPE;
            case "JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE" -> JIRA_PROJECT_EVENT_TYPE;
            case "AGILE_SPRINTS_SUB_CALENDAR_STORE" -> JIRA_AGILE_SPRINT_EVENT_TYPE;
            default -> eventType;
        };
        return eventType;
    }

    public static boolean isJiraEventType(String eventType) {
        return eventType.equals(JIRA_ISSUE_EVENT_TYPE) || eventType.equals(JIRA_AGILE_SPRINT_EVENT_TYPE) || eventType.equals(JIRA_PROJECT_EVENT_TYPE);
    }

    public static boolean isJiraStoreKey(String storeKey) {
        return storeKey.equals("JIRA_ISSUE_DATES_SUB_CALENDAR_STORE") || storeKey.equals("JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE") || storeKey.equals("AGILE_SPRINTS_SUB_CALENDAR_STORE");
    }

    public static String getI18nKeyForViewJiraIssueTextFromEventStoreKey(String storeKey) {
        if ("JIRA_ISSUE_DATES_SUB_CALENDAR_STORE".equals(storeKey)) {
            return "calendar3.reminder.view.jira.issue.link.text";
        }
        if ("JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE".equals(storeKey)) {
            return "calendar3.reminder.view.jira.project.link.text";
        }
        if ("AGILE_SPRINTS_SUB_CALENDAR_STORE".equals(storeKey)) {
            return "calendar3.reminder.view.jira.sprint.link.text";
        }
        return "";
    }

    public static String getStoreKeyFromEventType(String eventType) {
        String storeKey = switch (eventType) {
            case "other" -> "com.atlassian.confluence.extra.calendar3.calendarstore.generic.GenericLocalSubCalendarDataStore";
            case "birthdays" -> "com.atlassian.confluence.extra.calendar3.calendarstore.generic.BirthdaySubCalendarDataStore";
            case "leaves" -> "com.atlassian.confluence.extra.calendar3.calendarstore.generic.LeaveSubCalendarDataStore";
            case "travel" -> "com.atlassian.confluence.extra.calendar3.calendarstore.generic.TravelSubCalendarDataStore";
            case JIRA_ISSUE_EVENT_TYPE -> "JIRA_ISSUE_DATES_SUB_CALENDAR_STORE";
            case JIRA_PROJECT_EVENT_TYPE -> "JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE";
            case JIRA_AGILE_SPRINT_EVENT_TYPE -> "AGILE_SPRINTS_SUB_CALENDAR_STORE";
            default -> "";
        };
        return storeKey;
    }

    public static String getEventTypePropertyFromStoreKey(String storeKey) {
        String eventTypeProperty = switch (storeKey) {
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.GenericLocalSubCalendarDataStore" -> "calendar3.event.type.other";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.BirthdaySubCalendarDataStore" -> "calendar3.event.type.birthdays";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.LeaveSubCalendarDataStore" -> "calendar3.event.type.leaves";
            case "com.atlassian.confluence.extra.calendar3.calendarstore.generic.TravelSubCalendarDataStore" -> "calendar3.event.type.travel";
            case "JIRA_ISSUE_DATES_SUB_CALENDAR_STORE" -> "calendar3.subcalendar.type.jira-issue-dates";
            case "JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE" -> "calendar3.subcalendar.type.jira-project-releases";
            case "AGILE_SPRINTS_SUB_CALENDAR_STORE" -> "calendar3.subcalendar.type.jira-agile-sprint";
            default -> "";
        };
        return eventTypeProperty;
    }

    public static Date getUtcTime(DateProperty dateProperty) {
        Date returnVal;
        TimeZone originalTimezone = dateProperty.getTimeZone();
        try {
            dateProperty.setUtc(true);
            returnVal = dateProperty.getDate();
        }
        finally {
            dateProperty.setTimeZone(originalTimezone);
        }
        return returnVal;
    }

    public static Date convertToUtcTime(DateProperty dateProperty) {
        dateProperty.setUtc(true);
        return dateProperty.getDate();
    }

    public static DateTime getUtcDateTimeWithAllDay(Date dateTime) {
        DateTime startDateTime = new DateTime((Object)dateTime);
        return startDateTime.withTime(0, 0, 0, 0).withZone(DateTimeZone.UTC);
    }

    public static String getIcalFormatDateTime(String dt) {
        if (dt == null) {
            return null;
        }
        if (dt.charAt(4) != '-') {
            return dt;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dt.substring(0, 4));
        sb.append(dt.substring(5, 7));
        sb.append(dt.substring(8, 10));
        if (dt.length() > 10) {
            sb.append("T");
            sb.append(dt.substring(11, 13));
            sb.append(dt.substring(14, 16));
            sb.append(dt.substring(17, 19));
            if (dt.endsWith("Z")) {
                sb.append("Z");
            }
        }
        return sb.toString();
    }

    public static net.fortuna.ical4j.model.DateTime toIcal4jDateTime(JodaIcal4jTimeZoneMapper jodaIcal4jTimeZoneMapper, DateTime jodaDate) {
        net.fortuna.ical4j.model.DateTime dateTime = new net.fortuna.ical4j.model.DateTime(jodaDate.getMillis());
        dateTime.setTimeZone(jodaIcal4jTimeZoneMapper.toIcal4jTimeZone(jodaDate.getZone().getID()));
        return dateTime;
    }

    public static Date toIcal4jDate(DateTime jodaDate) {
        try {
            return new Date(DateTimeFormat.forPattern((String)"yyyyMMdd").withZone(jodaDate.getZone()).print((ReadableInstant)jodaDate));
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static String buildString(StringBuilder buffer, Object ... args) {
        buffer.setLength(0);
        for (Object str : args) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String getVersionUrl(StringBuilder stringBuilder, VEvent raw, String jiraDisplayUrl) {
        Property versionId = raw.getProperty("X-JIRA-VERSION-ID");
        if (versionId == null) {
            Url urlProperty = raw.getUrl();
            return urlProperty == null ? null : urlProperty.getValue();
        }
        return CalendarUtil.buildString(stringBuilder, jiraDisplayUrl, "/browse/", CalendarUtil.getProject(raw).getKey(), "/fixforversion/", versionId.getValue());
    }

    public static Project getProject(VEvent raw) {
        Property projectProperty = raw.getProperty("X-JIRA-PROJECT");
        if (projectProperty == null) {
            return new Project(raw.getProperty("X-JIRA-PROJECT-NAME").getValue(), null, null);
        }
        return new Project(projectProperty.getValue(), projectProperty.getParameter("X-JIRA-PROJECT-KEY").getValue(), projectProperty.getParameter("X-JIRA-PROJECT-ID").getValue());
    }

    public static boolean isJiraVersion(VEvent raw) {
        Url url = raw.getUrl();
        return url == null ? raw.getProperty("X-JIRA-VERSION-ID") != null : VERSION_EVENT_PATTERN.matcher(url.getValue()).matches();
    }

    public static boolean isGreenHopperSprint(VEvent raw) {
        return raw.getProperty("X-GREENHOPPER-SPRINT-CLOSED") != null;
    }

    public static String getIssueUrl(StringBuilder stringBuilder, VEvent raw, String jiraDisplayUrl) {
        Url url = raw.getUrl();
        if (url != null) {
            return CalendarUtil.rebaseUrl(BASE_URL_REPLACE_FOR_BROWSE, url.getValue(), CalendarUtil.buildString(stringBuilder, jiraDisplayUrl, "/browse/"));
        }
        if (raw.getProperty("X-JIRA-ISSUE-KEY") != null) {
            return CalendarUtil.buildString(stringBuilder, jiraDisplayUrl, "/browse/", raw.getProperty("X-JIRA-ISSUE-KEY").getValue());
        }
        return null;
    }

    public static String rebaseUrl(Pattern aPattern, String url, String newBaseUrl) {
        Matcher urlMatcher = aPattern.matcher(url);
        return urlMatcher.lookingAt() ? urlMatcher.replaceFirst(newBaseUrl) : url;
    }

    public static String getProjectNameFromJiraRawEvent(VEvent rawEvent) {
        Property projectProperty = rawEvent.getProperty("X-JIRA-PROJECT");
        if (projectProperty == null) {
            Property property = rawEvent.getProperty("X-JIRA-PROJECT-NAME");
            return property != null ? property.getValue() : "";
        }
        return projectProperty.getValue();
    }

    public static boolean isNewDashBoard() {
        block6: {
            String version = StringUtils.split((String)BuildInformation.INSTANCE.getVersionNumber(), (String)"-")[0];
            String[] splitedVersionString = StringUtils.split((String)version, (String)".");
            ArrayList<Integer> splitedVersionInt = new ArrayList<Integer>(splitedVersionString.length);
            for (String aSplitedVersionString : splitedVersionString) {
                splitedVersionInt.add(Integer.parseInt(aSplitedVersionString));
            }
            if ((Integer)splitedVersionInt.get(0) == 5) {
                if ((Integer)splitedVersionInt.get(1) == 9) {
                    try {
                        if ((Integer)splitedVersionInt.get(2) >= 1) {
                            return true;
                        }
                        break block6;
                    }
                    catch (IndexOutOfBoundsException e) {
                        return false;
                    }
                }
                return (Integer)splitedVersionInt.get(1) > 9;
            }
            return (Integer)splitedVersionInt.get(0) > 5;
        }
        return false;
    }

    public static class Project
    extends com.atlassian.confluence.extra.calendar3.model.Project {
        private final String projectId;

        private Project(String name, String key, String projectId) {
            super(name, key);
            this.projectId = projectId;
        }

        public String getProjectId() {
            return this.projectId;
        }
    }
}

