/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.util;

import com.atlassian.confluence.extra.calendar3.util.AbstractBuildInformationManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="buildInformationManager")
@ExportAsService
public class DefaultBuildInformationManager
extends AbstractBuildInformationManager
implements LifecycleAware,
InitializingBean {
    private static final String BUILD_INFORMATION_PLUGIN_SETTINGS_NAMESPACE = DefaultBuildInformationManager.getBuildInformationPluginSettingsNamespace(DigestUtils.sha1Hex((String)DefaultBuildInformationManager.class.getName()));
    public static final String PLUGIN_SETTINGS_KEY_MIGRATION_CUTOFF_DATE_MILLIS = "legacySubCalendarsMigrationCutoffDate";
    private String pluginKey;
    private String version;
    private DateTime legacySubCalendarsMigrationCutoffDate;
    private final PluginSettings pluginSettings;

    public static String getBuildInformationPluginSettingsNamespace(String key) {
        String CONTEXT_KEY_PREFIX = "_CALENDAR";
        return CONTEXT_KEY_PREFIX + "_" + key;
    }

    public static String getBuildInformationPluginSettingsNamespace(String key, String subCalendarId) {
        if (StringUtils.isBlank((CharSequence)subCalendarId)) {
            throw new IllegalArgumentException("Blank sub-calendar ID specified");
        }
        return DefaultBuildInformationManager.getBuildInformationPluginSettingsNamespace(key) + "_" + subCalendarId;
    }

    @Autowired
    public DefaultBuildInformationManager(@ComponentImport @Qualifier(value="pluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(BUILD_INFORMATION_PLUGIN_SETTINGS_NAMESPACE);
    }

    public void onStart() {
        this.initLegacySubCalendarsMigrationCuffoffDate();
    }

    public void onStop() {
    }

    public void afterPropertiesSet() throws Exception {
        this.initPropertiesFromPluginDescriptor();
    }

    private void initLegacySubCalendarsMigrationCuffoffDate() {
        Long cutoffDateMillis = (Long)this.pluginSettings.get(PLUGIN_SETTINGS_KEY_MIGRATION_CUTOFF_DATE_MILLIS);
        if (cutoffDateMillis != null) {
            this.legacySubCalendarsMigrationCutoffDate = new DateTime(cutoffDateMillis.longValue());
        } else {
            this.legacySubCalendarsMigrationCutoffDate = new DateTime(System.currentTimeMillis());
            this.pluginSettings.put(PLUGIN_SETTINGS_KEY_MIGRATION_CUTOFF_DATE_MILLIS, (Object)this.legacySubCalendarsMigrationCutoffDate.getMillis());
        }
    }

    private void initPropertiesFromPluginDescriptor() throws DocumentException, IOException {
        try (InputStream pluginDescInputStream = this.getClass().getClassLoader().getResourceAsStream("atlassian-plugin.xml");){
            SAXReader saxReader = new SAXReader();
            Document pluginDescDoc = saxReader.read(pluginDescInputStream);
            Element root = pluginDescDoc.getRootElement();
            this.pluginKey = root.attribute("key").getValue();
            this.version = root.element("plugin-info").element("version").getTextTrim();
        }
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getVersion() {
        return this.version;
    }

    public DateTime getLegacySubCalendarsMigrationCutoffDate() {
        return this.legacySubCalendarsMigrationCutoffDate;
    }

    public boolean isNotificationsEnabled() {
        return BooleanUtils.toBoolean((String)System.getProperty("com.atlassian.confluence.extra.calendar3.notification.enabled", "true"));
    }

    public boolean isShowingWhatsNew() {
        return BooleanUtils.toBoolean((String)System.getProperty("com.atlassian.confluence.extra.calendar3.whatsnew.enabled", "false"));
    }

    public boolean isWorkboxNotificationEnabled() {
        return BooleanUtils.toBoolean((String)System.getProperty("com.atlassian.confluence.extra.calendar3.notification.workbox.enabled", "false"));
    }
}

