/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprintEventTransformer {
    private static final Logger logger = LoggerFactory.getLogger(SprintEventTransformer.class);
    private final String subCalendarType;
    private final SimpleDateFormat allDayDateFormat;

    public SprintEventTransformer(String subCalendarType) {
        this.subCalendarType = subCalendarType;
        this.allDayDateFormat = new SimpleDateFormat("yyyyMMdd");
    }

    public VEvent transform(VEvent eventComponent) {
        if (!StringUtils.equals((CharSequence)"jira-agile-sprint", (CharSequence)this.subCalendarType)) {
            return eventComponent;
        }
        DtStart dtStart = (DtStart)eventComponent.getProperty("DTSTART");
        DtEnd dtEnd = (DtEnd)eventComponent.getProperty("DTEND");
        try {
            net.fortuna.ical4j.model.Date startDate = new net.fortuna.ical4j.model.Date(this.allDayDateFormat.format((Date)dtStart.getDate()));
            dtStart.setDate(startDate);
            net.fortuna.ical4j.model.Date endDate = new net.fortuna.ical4j.model.Date(this.allDayDateFormat.format((Date)dtEnd.getDate()));
            dtEnd.setDate(endDate);
        }
        catch (ParseException e) {
            logger.error("Could not reset DtStart and DtEnd for Jira Sprint Issues");
        }
        return eventComponent;
    }
}

