/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.util;

import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import java.security.InvalidParameterException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.transform.Transformer;

public class TextLimitICalTransformer
implements Transformer<Calendar> {
    private final int numOfWordLimit;

    public TextLimitICalTransformer(int numOfWordLimit) {
        if (numOfWordLimit < 0) {
            throw new InvalidParameterException("Number of word limit much greater than zero");
        }
        this.numOfWordLimit = numOfWordLimit;
    }

    public Calendar transform(Calendar calendar) {
        ComponentList vEvents = calendar.getComponents("VEVENT");
        vEvents.forEach(vEvent -> {
            Description description;
            PropertyList eventProperties = vEvent.getProperties();
            Summary summary = (Summary)eventProperties.getProperty("SUMMARY");
            if (summary != null) {
                summary.setValue(CalendarUtil.limitByWord(summary.getValue(), this.numOfWordLimit));
            }
            if ((description = (Description)eventProperties.getProperty("DESCRIPTION")) != null) {
                description.setValue(CalendarUtil.limitByWord(description.getValue(), this.numOfWordLimit));
            }
        });
        return calendar;
    }
}

