/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.watchdog;

import com.atlassian.confluence.extra.calendar3.util.AsynchronousTaskExecutor;
import com.atlassian.confluence.extra.calendar3.watchdog.WatchDogService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class WatchDogActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchDogActivator.class);
    private final AsynchronousTaskExecutor asynchronousTaskExecutor;
    private final WatchDogService watchDogService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public WatchDogActivator(AsynchronousTaskExecutor asynchronousTaskExecutor, @ComponentImport TransactionTemplate transactionTemplate, WatchDogService watchDogService) {
        this.asynchronousTaskExecutor = asynchronousTaskExecutor;
        this.watchDogService = watchDogService;
        this.transactionTemplate = transactionTemplate;
    }

    public void startWatchDog() {
        LOGGER.info("Starting Watch Dog Service ");
        this.asynchronousTaskExecutor.submit(() -> {
            this.transactionTemplate.execute(this.watchDogService::startService);
            LOGGER.info("Watch Dog Service has finished checking");
            return null;
        });
        LOGGER.info("Starting Watch Dog Service ===> completed");
    }
}

