/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.watchdog.impl;

import com.atlassian.confluence.extra.calendar3.model.persistence.EventRecurrenceExclusionEntity;
import com.atlassian.confluence.extra.calendar3.querydsl.QueryDSLMapper;
import com.atlassian.confluence.extra.calendar3.querydsl.QueryDSLSupplier;
import com.atlassian.confluence.extra.calendar3.querydsl.mappings.EventRecurrenceExclusionTable;
import com.atlassian.confluence.extra.calendar3.watchdog.WatchDogStatusReporter;
import com.atlassian.confluence.extra.calendar3.watchdog.WatchDogTask;
import com.atlassian.confluence.extra.calendar3.watchdog.impl.DuplicatedEventRecurrenceExclusion;
import com.atlassian.confluence.extra.calendar3.watchdog.impl.cleaner.EventDuplicatedDataCleaner;
import com.atlassian.confluence.extra.calendar3.watchdog.impl.cleaner.EventDuplicatedDataCleanerSpec;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DuplicateEventRecurrenceExclusionWatchDogTask
implements WatchDogTask,
EventDuplicatedDataCleanerSpec<DuplicatedEventRecurrenceExclusion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateEventRecurrenceExclusionWatchDogTask.class);
    private static final int NUM_DUPLICATED_EVENT_PER_LOOP = 100;
    private static final int NUM_DELETE_ROW_PER_LOOP = 1000;
    private final TransactionalHostContextAccessor hostContextAccessor;
    private final QueryDSLMapper queryDSLMapper;
    private final QueryDSLSupplier sqlQuerySupplier;

    @Autowired
    @VisibleForTesting
    public DuplicateEventRecurrenceExclusionWatchDogTask(@ComponentImport TransactionalHostContextAccessor hostContextAccessor, QueryDSLMapper queryDSLMapper, QueryDSLSupplier queryDSLSupplier) {
        this.hostContextAccessor = hostContextAccessor;
        this.queryDSLMapper = queryDSLMapper;
        this.sqlQuerySupplier = queryDSLSupplier;
    }

    @Override
    public boolean shouldRun() {
        EventRecurrenceExclusionTable exclusionTable = (EventRecurrenceExclusionTable)this.queryDSLMapper.getMapping(EventRecurrenceExclusionEntity.class);
        boolean hasDuplication = this.sqlQuerySupplier.executeSQLQuery(query -> ((SQLQuery)((SQLQuery)((SQLQuery)query.select(exclusionTable.EVENT_ID).from((Expression)exclusionTable)).groupBy(new Expression[]{exclusionTable.EVENT_ID, exclusionTable.EXCLUSION, exclusionTable.ALL_DAY})).having((Predicate)exclusionTable.EXCLUSION.count().gt((Number)1))).fetchFirst() != null);
        if (hasDuplication) {
            LOGGER.info("Duplicate data has been detected in the event exclusion table. A clean up task will be run.");
        }
        return hasDuplication;
    }

    @Override
    public void run(WatchDogStatusReporter reporter) {
        EventDuplicatedDataCleaner<DuplicatedEventRecurrenceExclusion> duplicationCleaner = new EventDuplicatedDataCleaner<DuplicatedEventRecurrenceExclusion>(this.hostContextAccessor, 100, 1000, this, reporter);
        duplicationCleaner.cleanData();
    }

    @Override
    public Collection<DuplicatedEventRecurrenceExclusion> getDuplicatedDTOs(int duplicatedEventPage, int duplicateEventLassOffset) {
        EventRecurrenceExclusionTable exclusionTable = (EventRecurrenceExclusionTable)this.queryDSLMapper.getMapping(EventRecurrenceExclusionEntity.class);
        return this.sqlQuerySupplier.executeSQLQuery(query -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)query.from((Expression)exclusionTable)).groupBy(new Expression[]{exclusionTable.EVENT_ID, exclusionTable.EXCLUSION, exclusionTable.ALL_DAY})).having((Predicate)exclusionTable.EXCLUSION.count().gt((Number)1))).orderBy(exclusionTable.EXCLUSION.count().asc())).limit((long)duplicatedEventPage)).offset((long)duplicateEventLassOffset)).select((Expression)Projections.constructor(DuplicatedEventRecurrenceExclusion.class, (Expression[])new Expression[]{exclusionTable.ID.min().as("MIN_ID"), exclusionTable.EVENT_ID, exclusionTable.EXCLUSION, exclusionTable.ALL_DAY})).fetch());
    }

    @Override
    public long getDuplicatedCountPerDTO(DuplicatedEventRecurrenceExclusion duplicatedDTO) {
        EventRecurrenceExclusionTable exclusionTable = (EventRecurrenceExclusionTable)this.queryDSLMapper.getMapping(EventRecurrenceExclusionEntity.class);
        return this.sqlQuerySupplier.executeSQLQuery(query -> {
            SQLQuery countDuplicatedPerEventQuery = (SQLQuery)((SQLQuery)((SQLQuery)query.select(exclusionTable.ID).from((Expression)exclusionTable)).groupBy(new Expression[]{exclusionTable.EVENT_ID, exclusionTable.EXCLUSION, exclusionTable.ALL_DAY})).where((Predicate)exclusionTable.ID.eq((Object)duplicatedDTO.getId()).and((Predicate)exclusionTable.EVENT_ID.eq((Object)duplicatedDTO.getEventId())).and((Predicate)exclusionTable.EXCLUSION.eq((Object)duplicatedDTO.getExclusion())).and((Predicate)exclusionTable.ALL_DAY.eq(Boolean.valueOf(duplicatedDTO.isAllDay()))));
            return countDuplicatedPerEventQuery.fetchCount();
        });
    }

    @Override
    public long deleteDuplicatedRow(int limit, DuplicatedEventRecurrenceExclusion duplicatedDTO) {
        EventRecurrenceExclusionTable exclusionTable = (EventRecurrenceExclusionTable)this.queryDSLMapper.getMapping(EventRecurrenceExclusionEntity.class);
        return this.sqlQuerySupplier.executeDeleteSQLClause((RelationalPath<?>)exclusionTable, sqlDeleteClause -> {
            sqlDeleteClause.where((Predicate)exclusionTable.ID.ne((Object)duplicatedDTO.getId()).and((Predicate)exclusionTable.EVENT_ID.eq((Object)duplicatedDTO.getEventId())).and((Predicate)exclusionTable.EXCLUSION.eq((Object)duplicatedDTO.getExclusion())).and((Predicate)exclusionTable.ALL_DAY.eq(Boolean.valueOf(duplicatedDTO.isAllDay()))));
            if (limit > 1) {
                LOGGER.debug("Going to set the limit for the delete statement to [{}]", (Object)limit);
                sqlDeleteClause.limit((long)limit);
            }
            long deletedRow = sqlDeleteClause.execute();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleted [{}] rows in the {} table", (Object)deletedRow, (Object)exclusionTable);
            }
            return deletedRow;
        });
    }
}

