/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.bootstrap;

public class CheckJavaVersion {
    public static final String WARNING_MESSAGE = "Found Java version %d but expected at least %d";
    public static final String MISSING_ARG_ERROR_MESSAGE = "Incorrect usage. You must supply the minimum JVM number int value as the first argument.";
    public static final String INVALID_INT_ERROR_MESSAGE = "Invalid version number. You must supply the minimum JVM number int value as the first argument.";

    public static void main(String[] args) {
        int minJavaVersion;
        if (args == null || args.length == 0) {
            System.out.print(MISSING_ARG_ERROR_MESSAGE);
            return;
        }
        try {
            minJavaVersion = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.print(INVALID_INT_ERROR_MESSAGE);
            return;
        }
        int SystemJavaVersion = CheckJavaVersion.getVersion();
        if (SystemJavaVersion >= minJavaVersion) {
            System.out.print("true");
        } else {
            System.out.printf(WARNING_MESSAGE, SystemJavaVersion, minJavaVersion);
        }
    }

    private static int getVersion() {
        try {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            return Integer.parseInt(version);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

