/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.lookandfeel;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.CustomDarkLogoResetEvent;
import com.atlassian.confluence.event.events.admin.CustomDarkLogoUploadEvent;
import com.atlassian.confluence.event.events.admin.CustomLightLogoResetEvent;
import com.atlassian.confluence.event.events.admin.CustomLightLogoUndoColourSchemeEvent;
import com.atlassian.confluence.event.events.admin.CustomLightLogoUploadEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.plugins.lookandfeel.AutoLookAndFeelManager;
import com.atlassian.confluence.plugins.lookandfeel.SiteLogoManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.themes.events.FaviconChangedEvent;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.favicon.core.Constants;
import com.atlassian.favicon.core.Favicon;
import com.atlassian.favicon.core.FaviconManager;
import com.atlassian.favicon.core.ImageType;
import com.atlassian.favicon.core.UploadedFaviconFile;
import com.atlassian.favicon.core.exceptions.MessageKeyedException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class EditSiteLogoAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(EditSiteLogoAction.class);
    private SoyTemplateRenderer soyTemplateRenderer;
    private SiteLogoManager siteLogoManager;
    private SiteLogoManager darkSiteLogoManager;
    private XsrfTokenGenerator tokenGenerator;
    private AutoLookAndFeelManager autoLookAndFeelManager;
    private I18nResolver i18nResolver;
    private FaviconManager faviconManager;
    private String siteTitle;
    private boolean showBothLogoAndTitle;
    private String showOptions;
    private boolean colorSchemeUpdated;
    private boolean faviconUpdated;
    private boolean faviconReset;

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() {
        if (this.isFaviconUpdated()) {
            this.addActionMessage(this.getText("custom.favicon.admin.upload.complete"));
        }
        if (this.isFaviconReset()) {
            this.addActionMessage(this.getText("custom.favicon.admin.reset.complete"));
        }
        Settings globalSettings = this.getGlobalSettings();
        this.showBothLogoAndTitle = globalSettings.showApplicationTitle();
        this.siteTitle = globalSettings.getSiteTitle();
        return "success";
    }

    private String uploadLightThemeLogo(List<UploadedFile> uploadedFiles) {
        Optional<UploadedFile> logoFile = uploadedFiles.stream().filter(file -> file.getParameterName().equals("logoFile")).findFirst();
        if (logoFile.isPresent()) {
            this.updateSiteLogo(logoFile.get(), this.siteLogoManager);
            if (this.hasErrors()) {
                log.error("Site logo upload failed: {}", (Object)this.getActionErrors());
                return "error";
            }
            log.info("Succeeded in uploading new site logo [{}]", (Object)logoFile.get().getFileName());
            this.eventPublisher.publish((Object)new CustomLightLogoUploadEvent((Object)this));
            this.autoLookAndFeelManager.backupColorScheme();
            try {
                this.autoLookAndFeelManager.generateFromSiteLogo();
                this.colorSchemeUpdated = true;
            }
            catch (Exception e) {
                log.error("Failed to generate color scheme from site logo", (Throwable)e);
                this.autoLookAndFeelManager.restoreBackupColorScheme();
                this.colorSchemeUpdated = false;
            }
        }
        return "success";
    }

    private String uploadDarkThemeLogo(List<UploadedFile> uploadedFiles) {
        Optional<UploadedFile> darkLogoFile = uploadedFiles.stream().filter(file -> file.getParameterName().equals("darkLogoFile")).findFirst();
        if (darkLogoFile.isPresent()) {
            this.updateSiteLogo(darkLogoFile.get(), this.darkSiteLogoManager);
            if (this.hasErrors()) {
                log.error("Dark site logo upload failed: {}", (Object)this.getActionErrors());
                return "error";
            }
            log.info("Succeeded in uploading new dark site logo [{}]", (Object)darkLogoFile.get().getFileName());
            this.eventPublisher.publish((Object)new CustomDarkLogoUploadEvent((Object)this));
        }
        return "success";
    }

    public String doUpload() {
        List uploadedFiles;
        try {
            uploadedFiles = this.strutsHelper.getUploadedFiles(this.getActiveRequest());
        }
        catch (Exception e) {
            String errorMsg = this.getText("lookandfeel.sitelogo.admin.logo.upload.error");
            log.error(errorMsg, (Throwable)e);
            this.addFieldError("logoFile", errorMsg);
            return "error";
        }
        if (this.uploadLightThemeLogo(uploadedFiles).equals("error")) {
            return "error";
        }
        if (this.uploadDarkThemeLogo(uploadedFiles).equals("error")) {
            return "error";
        }
        Settings globalSettings = this.getGlobalSettings();
        Settings newSettings = new Settings(globalSettings);
        newSettings.setShowApplicationTitle(this.showBothLogoAndTitle);
        newSettings.setSiteTitle(this.siteTitle);
        this.globalSettingsManager.updateGlobalSettings(newSettings);
        this.eventPublisher.publish((Object)new GlobalSettingsChangedEvent((Object)this, globalSettings, newSettings));
        log.info("Updated site title to [{}]", (Object)this.siteTitle);
        return "success";
    }

    private void updateSiteLogo(UploadedFile uploadedFile, SiteLogoManager logoManager) {
        try {
            logoManager.uploadLogo(uploadedFile.getFile(), uploadedFile.getContentType());
        }
        catch (UnsupportedOperationException e) {
            log.info("Failed to upload new site logo", (Throwable)e);
            this.addActionError(this.getText("lookandfeel.sitelogo.admin.logo.upload.mimetype.unsupported.error", new Object[]{uploadedFile.getContentType()}));
        }
        catch (IOException e) {
            log.warn("Failed to upload new site logo", (Throwable)e);
            this.addActionError(this.getText("lookandfeel.sitelogo.admin.logo.upload.error "));
        }
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doReset() {
        this.siteLogoManager.resetToDefault();
        this.autoLookAndFeelManager.restoreDefaultColorScheme();
        this.eventPublisher.publish((Object)new CustomLightLogoResetEvent((Object)this));
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDarkLogoReset() {
        this.darkSiteLogoManager.resetToDefault();
        this.eventPublisher.publish((Object)new CustomDarkLogoResetEvent((Object)this));
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doRestoreColorScheme() {
        this.autoLookAndFeelManager.restoreBackupColorScheme();
        this.eventPublisher.publish((Object)new CustomLightLogoUndoColourSchemeEvent((Object)this));
        return "success";
    }

    public String getLogoFormAsHtml() {
        try {
            String xsrfToken = this.tokenGenerator.generateToken(ServletActionContext.getRequest());
            HashMap<String, Object> soyRenderData = new HashMap<String, Object>();
            soyRenderData.put("atlToken", xsrfToken);
            soyRenderData.put("uploadAction", "upload.action");
            soyRenderData.put("resetAction", "reset.action?atl_token=" + xsrfToken);
            soyRenderData.put("resetDarkLogoAction", "resetDarkLogo.action?atl_token=" + xsrfToken);
            soyRenderData.put("undoColorSchemeAction", "restoreColorScheme.action?atl_token=" + xsrfToken);
            soyRenderData.put("isNotDefault", this.siteLogoManager.useCustomLogo());
            soyRenderData.put("isDarkLogoUploaded", this.darkSiteLogoManager.useCustomLogo());
            soyRenderData.put("siteTitle", this.getGlobalSettings().getSiteTitle());
            soyRenderData.put("showBothLogoAndTitle", this.showBothLogoAndTitle);
            soyRenderData.put("fieldErrors", this.getFieldErrors());
            soyRenderData.put("colorSchemeUpdated", this.colorSchemeUpdated);
            return this.soyTemplateRenderer.render("com.atlassian.confluence.plugins.confluence-lookandfeel:sitelogo-resources", "Confluence.Templates.LookandFeelLogo.logoForm", soyRenderData);
        }
        catch (SoyException e) {
            log.debug("Could not render soy template for ");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public String getFaviconFormAsHtml() {
        try {
            String xsrfToken = this.tokenGenerator.generateToken(ServletActionContext.getRequest());
            String faviconURL = String.format("%s/%s", this.getGlobalSettings().getBaseUrl(), this.generateFaviconFilename());
            HashMap<String, Object> soyRenderData = new HashMap<String, Object>();
            soyRenderData.put("atlToken", xsrfToken);
            soyRenderData.put("imageWithContext", faviconURL);
            soyRenderData.put("isNotDefault", this.faviconManager.isFaviconConfigured());
            soyRenderData.put("uploadAction", "uploadFavicon.action");
            soyRenderData.put("resetAction", "resetFavicon.action?atl_token=" + xsrfToken);
            soyRenderData.put("actionErrors", new ArrayList());
            soyRenderData.put("actionMessages", new ArrayList());
            return this.soyTemplateRenderer.render("com.atlassian.favicon.confluence-custom-favicon-plugin:favicon-soy", "Custom.Favicon.Templates.configureForm", soyRenderData);
        }
        catch (SoyException e) {
            log.debug("Could not render soy template for favicon configuration", (Throwable)e);
            return null;
        }
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doFaviconReset() {
        this.faviconManager.resetFavicon();
        this.eventPublisher.publish((Object)new FaviconChangedEvent((Object)this, FaviconChangedEvent.Action.RESET));
        return "success";
    }

    public String doFaviconUpload() {
        try {
            AtlassianJakartaMultiPartRequest unwrapped = this.strutsHelper.unwrapMultiPartRequest(this.getActiveRequest());
            if (unwrapped == null) {
                return "success";
            }
            List files = Collections.emptyList();
            try {
                files = this.strutsHelper.getUploadedFiles((HttpServletRequest)unwrapped);
            }
            catch (FileUploadException e) {
                log.debug("Could not read uploaded file", (Throwable)e);
            }
            if (files.isEmpty()) {
                this.addActionError(this.getText("custom.favicon.admin.upload.error"));
                return "error";
            }
            UploadedFile file = (UploadedFile)files.get(0);
            Optional imageType = ImageType.parseFromContentType((String)file.getContentType());
            if (!imageType.isPresent()) {
                this.addActionError(this.getText("custom.favicon.unsupported.image.type", file.getContentType()));
                return "error";
            }
            this.faviconManager.setFavicon(new UploadedFaviconFile(file.getFile(), (ImageType)imageType.get()));
            this.eventPublisher.publish((Object)new FaviconChangedEvent((Object)this, FaviconChangedEvent.Action.UPLOADED));
        }
        catch (MessageKeyedException e) {
            this.addActionError(this.getText(e.getMessageKey(), e.getArguments()));
            return "error";
        }
        catch (Exception e) {
            log.warn("Unexpected error uploading the favicon image", (Throwable)e);
            return "error";
        }
        return "success";
    }

    private String generateFaviconFilename() {
        if (this.faviconManager.isFaviconConfigured()) {
            return Favicon.generateFilename((ImageType)ImageType.PNG, (ThumbnailDimension)Constants.MAX_DIMENSION);
        }
        return "favicon.ico";
    }

    public SiteLogoManager getSiteLogoManager() {
        return this.siteLogoManager;
    }

    public SiteLogoManager getDarkSiteLogoManager() {
        return this.darkSiteLogoManager;
    }

    public void setSiteLogoManager(@Qualifier(value="LightSiteLogoManager") SiteLogoManager siteLogoManager) {
        this.siteLogoManager = siteLogoManager;
    }

    public void setDarkSiteLogoManager(@Qualifier(value="DarkSiteLogoManager") SiteLogoManager darkSiteLogoManager) {
        this.darkSiteLogoManager = darkSiteLogoManager;
    }

    public SoyTemplateRenderer getSoyTemplateRenderer() {
        return this.soyTemplateRenderer;
    }

    public void setSoyTemplateRenderer(@ComponentImport SoyTemplateRenderer soyTemplateRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public XsrfTokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public void setTokenGenerator(@ComponentImport XsrfTokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public AutoLookAndFeelManager getAutoLookAndFeelManager() {
        return this.autoLookAndFeelManager;
    }

    public void setAutoLookAndFeelManager(AutoLookAndFeelManager autoLookAndFeelManager) {
        this.autoLookAndFeelManager = autoLookAndFeelManager;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String getSiteTitle() {
        return this.siteTitle;
    }

    @StrutsParameter
    public void setSiteTitle(String siteTitle) {
        this.siteTitle = siteTitle;
    }

    public String getShowOptions() {
        return this.showOptions;
    }

    @StrutsParameter
    public void setShowOptions(String showOptions) {
        this.showOptions = showOptions;
        this.showBothLogoAndTitle = "both".equals(showOptions);
    }

    public boolean isColorSchemeUpdated() {
        return this.colorSchemeUpdated;
    }

    @StrutsParameter
    public void setColorSchemeUpdated(boolean colorSchemeUpdated) {
        this.colorSchemeUpdated = colorSchemeUpdated;
    }

    public void setFaviconManager(@ComponentImport FaviconManager faviconManager) {
        this.faviconManager = faviconManager;
    }

    public boolean isFaviconUpdated() {
        return this.faviconUpdated;
    }

    @StrutsParameter
    public void setFaviconUpdated(boolean faviconUpdated) {
        this.faviconUpdated = faviconUpdated;
    }

    public boolean isFaviconReset() {
        return this.faviconReset;
    }

    @StrutsParameter
    public void setFaviconReset(boolean faviconReset) {
        this.faviconReset = faviconReset;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }
}

