/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.lookandfeel.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.lookandfeel.SiteLogo;
import com.atlassian.confluence.plugins.lookandfeel.SiteLogoManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Qualifier;

@UnrestrictedAccess
public class LogoInterceptor
implements Filter {
    private static final String CONFLUENCE_LOGO = "confluence-logo.png";
    private FilterConfig filterConfig;
    private final SiteLogoManager siteLogoManager;

    public LogoInterceptor(@Qualifier(value="LightSiteLogoManager") SiteLogoManager siteLogoManager) {
        this.siteLogoManager = siteLogoManager;
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        SiteLogo siteLogo;
        HttpServletRequest req;
        String requestURL;
        if (request instanceof HttpServletRequest && (requestURL = (req = (HttpServletRequest)request).getRequestURL().toString()).endsWith(CONFLUENCE_LOGO) && this.siteLogoManager.useCustomLogo() && (siteLogo = this.siteLogoManager.getCurrent()) != null) {
            this.filterConfig.getServletContext().getRequestDispatcher(siteLogo.getDownloadPath()).forward(request, response);
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

