/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.ConfluenceException;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.mail.archive.MailAccount;
import com.atlassian.confluence.mail.archive.MailAccountManager;
import com.atlassian.confluence.mail.archive.MailContentManager;
import com.atlassian.confluence.mail.archive.MailPollResult;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.angus.mail.pop3.POP3Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailAccountManager
implements MailAccountManager {
    private static final String MAIL_POLLING_DISABLED_PROPERTY = "atlassian.mail.fetchdisabled";
    private static final String MAIL_ARCHIVING_PLUGIN_SECRET_PREFIX = "mail-archiving-plugin.";
    private static final Logger log = LoggerFactory.getLogger(DefaultMailAccountManager.class);
    private static final String MAIL_TIMEOUT_MILLIS = "60000";
    static final Map<String, String> OAUTH2_PROPERTIES = ImmutableMap.of((Object)"mail.imap.ssl.enable", (Object)"true", (Object)"mail.pop3s.ssl.enable", (Object)"true", (Object)"mail.imaps.auth.mechanisms", (Object)"XOAUTH2", (Object)"mail.pop3s.auth.mechanisms", (Object)"XOAUTH2");
    private final ClusterLockService clusterLockService;
    private final SpacePropertyService spacePropertyService;
    private final MailContentManager mailContentManager;
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final ClientTokenStorageService clientTokenStorageService;
    private final TokenHandler tokenHandler;
    private final SecretService secretService;
    private final ObjectMapper objectMapper = new ConfluenceJsonObjectMapper();

    public DefaultMailAccountManager(ClusterLockService clusterLockService, SpacePropertyService spacePropertyService, MailContentManager mailContentManager, SpaceManager spaceManager, SpaceService spaceService, ClientTokenStorageService clientTokenStorageService, TokenHandler tokenHandler, SecretService secretService) {
        this.clusterLockService = clusterLockService;
        this.spacePropertyService = spacePropertyService;
        this.mailContentManager = mailContentManager;
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.clientTokenStorageService = clientTokenStorageService;
        this.tokenHandler = tokenHandler;
        this.secretService = secretService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailPollResult updateAccountStatus(MailAccount mailAccount) {
        Store store = null;
        String mailAccountNameAndDescription = mailAccount.getName() + " (" + mailAccount.getDescription() + ")";
        try {
            store = this.getStore(mailAccount);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.getCause());
            MailPollResult mailPollResult = MailPollResult.failure(mailAccountNameAndDescription, e.getMessage());
            return mailPollResult;
        }
        finally {
            this.closeStore(store);
        }
        return MailPollResult.success(mailAccountNameAndDescription, 0);
    }

    @Override
    public List<MailPollResult> poll(Space space) {
        List<MailAccount> accounts = this.getMailAccounts(space);
        ArrayList<MailPollResult> results = new ArrayList<MailPollResult>(accounts.size());
        for (MailAccount mailAccount : accounts) {
            log.info("Checking for new mail in account {} for space {}", (Object)mailAccount.getName(), (Object)space.getKey());
            if (mailAccount.isEnabled()) {
                MailPollResult result = this.poll(space, mailAccount);
                log.info("New mail check complete for account {} in space {}: {}", new Object[]{mailAccount.getName(), space.getKey(), result});
                results.add(result);
                continue;
            }
            log.info("Account {} in space {} is disabled", (Object)mailAccount.getName(), (Object)space.getKey());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailPollResult poll(Space space, MailAccount mailAccount) {
        if (Boolean.getBoolean(MAIL_POLLING_DISABLED_PROPERTY)) {
            log.info("Mail polling is disabled via system property.");
            return MailPollResult.success("Mail polling is disabled via system property.", 0);
        }
        String mailAccountNameAndDescription = mailAccount.getName() + " (" + mailAccount.getDescription() + ")";
        ClusterLock lock = this.clusterLockService.getLockForName(mailAccount.lockName());
        if (!lock.tryLock()) {
            return MailPollResult.failure(mailAccountNameAndDescription, "Account is already being polled");
        }
        try {
            if (!mailAccount.isEnabled()) {
                MailPollResult mailPollResult = MailPollResult.failure(mailAccountNameAndDescription, "Account is not enabled");
                return mailPollResult;
            }
            MailPollResult mailPollResult = this.retrieveMessages(space, mailAccount);
            return mailPollResult;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailPollResult retrieveMessages(Space space, MailAccount mailAccount) throws MessagingException {
        Store store = null;
        Folder folder = null;
        try {
            store = this.getStore(mailAccount);
        }
        catch (Exception e) {
            log.error("Error connecting to {} for space {}: {}", new Object[]{mailAccount, space.getKey(), e.getMessage(), e.getCause()});
            MailPollResult mailPollResult = MailPollResult.failure(mailAccount.getName() + " (" + mailAccount.getDescription() + ")", e.getMessage());
            this.closeFolder(folder);
            this.closeStore(store);
            return mailPollResult;
        }
        try {
            folder = store.getFolder(mailAccount.getFolderName());
            folder.open(2);
            Message[] messages = folder.getMessages();
            int newMsgs = messages.length;
            log.debug("There are {} messages in the INBOX for Pop Account: {}", (Object)newMsgs, (Object)mailAccount.getName());
            for (Message message : messages) {
                MimeMessage msg = (MimeMessage)message;
                MimeMessage msgCopy = new MimeMessage(msg);
                if (msg instanceof POP3Message) {
                    POP3Message pop3Message = (POP3Message)msg;
                    pop3Message.invalidate(true);
                }
                try {
                    this.mailContentManager.storeIncomingMail(space, msgCopy);
                }
                catch (ConfluenceException e) {
                    log.warn("Could not store message within Confluence: [{}] - this message will be left on the server", (Object)msgCopy, (Object)e);
                    continue;
                }
                this.deleteMessageFromServer(msg);
            }
            MailPollResult mailPollResult = MailPollResult.success(mailAccount.getName() + " (" + mailAccount.getDescription() + ")", newMsgs);
            this.closeFolder(folder);
            this.closeStore(store);
            return mailPollResult;
        }
        catch (Throwable throwable) {
            this.closeFolder(folder);
            this.closeStore(store);
            throw throwable;
        }
    }

    private Optional<JsonSpaceProperty> getMailAccountsSpaceProperty(Space space) {
        return this.spacePropertyService.find(new Expansion[]{Expansion.combine((Object[])new Object[]{"version"})}).withSpaceKey(space.getKey()).withPropertyKey("atlassian.confluence.space.mailaccounts").fetch();
    }

    @Override
    public List<MailAccount> getMailAccounts(Space space) {
        List accounts;
        Optional<JsonSpaceProperty> accountsJson = this.getMailAccountsSpaceProperty(space);
        if (accountsJson.isEmpty()) {
            return new ArrayList<MailAccount>();
        }
        try {
            String jsonString = accountsJson.get().getValue().getValue();
            accounts = (List)this.objectMapper.readValue(jsonString, (TypeReference)new TypeReference<List<MailAccount>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        accounts.forEach(mailAccount -> this.maybeGetPasswordFromSecretService(space.getKey(), (MailAccount)mailAccount));
        return new ArrayList<MailAccount>(accounts);
    }

    @Override
    public MailAccount addMailAccount(Space space, MailAccount mailAccount) {
        List<MailAccount> mailAccounts = this.getMailAccounts(space);
        int id = 1;
        for (MailAccount account : mailAccounts) {
            if (account.getId() < id) continue;
            id = account.getId() + 1;
        }
        mailAccount.setId(id);
        mailAccounts.add(mailAccount);
        this.persistAccounts(space, mailAccounts);
        return mailAccount;
    }

    @Override
    public void removeMailAccount(Space space, int accountId) {
        List<MailAccount> mailAccounts = this.getMailAccounts(space);
        this.removeAccountFromList(mailAccounts, accountId);
        this.persistAccounts(space, mailAccounts);
        try {
            this.secretService.delete(DefaultMailAccountManager.getMailAccountSecretId(space.getKey(), accountId));
        }
        catch (SecretServiceException sse) {
            log.error("Failed to delete secret for mail account [{}] from secret service - {}", (Object)accountId, (Object)sse.getMessage());
        }
    }

    @Override
    public MailAccount getMailAccount(Space space, int accountId) {
        for (MailAccount account : this.getMailAccounts(space)) {
            if (account.getId() != accountId) continue;
            return account;
        }
        return null;
    }

    private void persistAccounts(Space space, List<MailAccount> newMailAccounts) {
        List<MailAccount> copied = DefaultMailAccountManager.deepCopyUsingSerialisation(newMailAccounts);
        if (SecretServiceState.ENABLED == SecretService.getState()) {
            copied.forEach(mailAccount -> this.maybeSecurePassword(space.getKey(), (MailAccount)mailAccount));
        }
        this.saveMailAccountsToSpaceProperties(space, copied);
    }

    private void saveMailAccountsToSpaceProperties(Space space, List<MailAccount> copied) {
        try {
            String json = this.objectMapper.writeValueAsString(copied);
            Optional spaceApi = this.spaceService.find(new Expansion[0]).withKeys(new String[]{space.getKey()}).fetch();
            if (spaceApi.isEmpty()) {
                throw new IllegalStateException("Space not found: " + space.getKey());
            }
            JsonSpaceProperty.SpacePropertyBuilder propertyBuilder = (JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space((com.atlassian.confluence.api.model.content.Space)spaceApi.get()).key("atlassian.confluence.space.mailaccounts")).value(new JsonString(json));
            Optional<JsonSpaceProperty> accountsJson = this.getMailAccountsSpaceProperty(space);
            if (accountsJson.isPresent()) {
                propertyBuilder.version(accountsJson.get().getVersion().nextBuilder().build());
                this.spacePropertyService.update(propertyBuilder.build());
            } else {
                this.spacePropertyService.create(propertyBuilder.build());
            }
            log.debug("Saving mail accounts for space {}: {}", (Object)space.getKey(), (Object)json);
        }
        catch (IOException e) {
            log.error("Unable to serialize mail accounts for space {}: {}", (Object)space.getKey(), (Object)e.getMessage());
        }
    }

    @Override
    public void updateAccount(Space space, MailAccount mailAccount) {
        List<MailAccount> mailAccounts = this.getMailAccounts(space);
        int id = mailAccount.getId();
        this.removeAccountFromList(mailAccounts, id);
        mailAccounts.add(mailAccount);
        this.persistAccounts(space, mailAccounts);
    }

    private void removeAccountFromList(List<MailAccount> mailAccounts, int id) {
        Iterator<MailAccount> iterator = mailAccounts.iterator();
        while (iterator.hasNext()) {
            MailAccount account = iterator.next();
            if (account.getId() != id) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public List<MailPollResult> pollAllSpaces() {
        ArrayList<MailPollResult> results = new ArrayList<MailPollResult>();
        ListBuilder listBuilder = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
        for (List spaces : listBuilder) {
            for (Space space : spaces) {
                results.addAll(this.poll(space));
            }
        }
        return results;
    }

    private Store getStore(MailAccount mailAccount) {
        try {
            Store store;
            boolean isBasicAuthentication = this.isBasicAuthentication(mailAccount);
            Properties props = this.getSessionProperties(isBasicAuthentication);
            Session session = Session.getInstance((Properties)props);
            if (isBasicAuthentication) {
                store = session.getStore(mailAccount.getProtocol());
                store.connect(mailAccount.getHostname(), mailAccount.getPort(), mailAccount.getUsername(), mailAccount.getPassword());
            } else {
                store = session.getStore(new URLName(mailAccount.getProtocol(), null, mailAccount.getPort(), null, null, null));
                ClientTokenEntity tokenEntity = this.clientTokenStorageService.getByIdOrFail(mailAccount.getToken());
                try {
                    store.connect(mailAccount.getHostname(), mailAccount.getUsername(), tokenEntity.getAccessToken());
                }
                catch (AuthenticationFailedException ex) {
                    log.debug("XOAUTH2 authentication to service {} failed. Trying to recover.", (Object)store.getURLName());
                    this.recoverOrRethrow(store, mailAccount.getUsername(), tokenEntity, ex);
                }
            }
            mailAccount.setStatus(store.isConnected());
            if (mailAccount.getStatus()) {
                return store;
            }
            throw new InfrastructureException("Unknown error connecting to mail account: " + String.valueOf(mailAccount));
        }
        catch (NoSuchProviderException e) {
            throw new InfrastructureException("Configuration error: Javamail could not find provider", (Throwable)e);
        }
        catch (Throwable t) {
            throw new InfrastructureException("Error connecting to mail server: " + t.getMessage(), t);
        }
    }

    private Properties getSessionProperties(boolean isBasicAuthentication) {
        Properties props = new Properties();
        this.setSocketTimeoutProperties("imap", props);
        this.setSocketTimeoutProperties("imaps", props);
        this.setSocketTimeoutProperties("pop3", props);
        this.setSocketTimeoutProperties("pop3s", props);
        props.setProperty("mail.debug", System.getProperty("mail.debug", "false"));
        if (!isBasicAuthentication) {
            OAUTH2_PROPERTIES.forEach(props::setProperty);
        }
        return props;
    }

    private void setSocketTimeoutProperties(String protocol, Properties properties) {
        properties.setProperty(String.format("mail.%s.timeout", protocol), MAIL_TIMEOUT_MILLIS);
        properties.setProperty(String.format("mail.%s.connectiontimeout", protocol), MAIL_TIMEOUT_MILLIS);
    }

    private void recoverOrRethrow(Store store, String username, ClientTokenEntity tokenEntity, AuthenticationFailedException originalEx) throws MessagingException {
        Optional<String> accessTokenOpt;
        if (this.isTokenRecoverable(tokenEntity) && (accessTokenOpt = this.refreshAccessToken(tokenEntity.getId())).isPresent()) {
            try {
                store.connect(username, tokenEntity.getAccessToken());
            }
            catch (MessagingException ex) {
                log.error("Issue connecting to store: [{}]", (Object)ex.getMessage(), (Object)ex);
            }
        }
        log.warn("Unable to refresh token: {}", (Object)tokenEntity.getId());
        throw originalEx;
    }

    private Optional<String> refreshAccessToken(String tokenId) {
        try {
            ClientToken clientToken = this.tokenHandler.getRefreshedToken(tokenId);
            return Optional.ofNullable(clientToken).map(ClientToken::getAccessToken);
        }
        catch (RecoverableTokenException | UnrecoverableTokenException ex) {
            log.debug("Access token can not be refreshed.", ex);
            return Optional.empty();
        }
    }

    private boolean isTokenRecoverable(ClientTokenEntity tokenEntity) {
        return !ClientTokenMetadata.ClientTokenStatus.UNRECOVERABLE.equals((Object)tokenEntity.getStatus());
    }

    private boolean isBasicAuthentication(MailAccount mailAccount) {
        return mailAccount.getAuthentication() == null || "BasicAuthentication".equals(mailAccount.getAuthentication());
    }

    private void deleteMessageFromServer(MimeMessage msg) throws MessagingException {
        try {
            msg.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            log.error("Could not delete email with messageId [{}] from {}\nPlease delete this message manually, as too many undeleteable messages will slow down Confluence", (Object)msg.getMessageID(), (Object)this);
        }
    }

    private void closeFolder(Folder folder) {
        try {
            if (folder != null) {
                folder.close(true);
            }
        }
        catch (Exception e) {
            log.error("Error closing folder", (Throwable)e);
        }
    }

    private void closeStore(Store store) {
        try {
            if (store != null) {
                store.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing store", (Throwable)e);
        }
    }

    static String getMailAccountSecretId(String spaceKey, int accountId) {
        return "mail-archiving-plugin.mail.server.password." + spaceKey + "." + accountId;
    }

    private void maybeGetPasswordFromSecretService(String spaceKey, MailAccount account) {
        if ("{ATL_SECURED}".equals(account.getPassword())) {
            try {
                Optional password = this.secretService.get(DefaultMailAccountManager.getMailAccountSecretId(spaceKey, account.getId()));
                if (password.isEmpty()) {
                    throw new IllegalStateException(String.format("Failed to fetch password for mail server [%s]. Expected secret [%s] not found.", account.getName(), DefaultMailAccountManager.getMailAccountSecretId(spaceKey, account.getId())));
                }
                account.setPassword((String)password.get());
            }
            catch (SecretServiceException sse) {
                log.error("Failed to fetch password for mail account [{}] from secret service - {}", (Object)account.getName(), (Object)sse.getMessage());
            }
        }
    }

    private void maybeSecurePassword(String spaceKey, MailAccount account) {
        if (account.getPassword() == null) {
            return;
        }
        try {
            this.secretService.put(DefaultMailAccountManager.getMailAccountSecretId(spaceKey, account.getId()), account.getPassword());
            account.setPassword("{ATL_SECURED}");
        }
        catch (SecretServiceException sse) {
            log.error("Failed to secure password for mail account [{}] to secret service - {}", (Object)account.getName(), (Object)sse.getMessage());
        }
    }

    private static List<MailAccount> deepCopyUsingSerialisation(List<MailAccount> accounts) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(accounts);
            oos.flush();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (List)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Unable to deep copy mail accounts.", e);
        }
    }
}

