/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.content;

import com.atlassian.confluence.content.ContentEntityAdapterParent;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.mail.archive.content.ContentBackedMail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.UrlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailContentEntityAdapter
extends ContentEntityAdapterParent {
    private static final Logger log = LoggerFactory.getLogger(MailContentEntityAdapter.class);
    public static final String PLUGIN_CONTENT_KEY = "com.atlassian.confluence.plugins.confluence-mail-archiving:mail";

    public Optional<String> urlPath(CustomContentEntityObject pluginContentEntityObject) {
        if (pluginContentEntityObject.getId() != 0L && pluginContentEntityObject.getSpace() != null) {
            return Optional.of("/display/" + pluginContentEntityObject.getSpace().getKey() + "/mail/" + pluginContentEntityObject.getId());
        }
        return Optional.empty();
    }

    public Optional<String> displayTitle(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.empty();
    }

    public Optional<String> nameForComparison(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.empty();
    }

    public Optional<String> attachmentsUrlPath(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.of(this.urlPath(pluginContentEntityObject).get() + "#attachments");
    }

    public Optional<String> attachmentUrlPath(CustomContentEntityObject pluginContentEntityObject, Attachment attachment) {
        return Optional.of(UrlUtils.appendAmpersandOrQuestionMark((String)this.urlPath(pluginContentEntityObject).get()) + "highlight=" + HtmlUtil.urlEncode((String)attachment.getFileName(), (Charset)GeneralUtil.getDefaultCharset()) + "#attachments");
    }

    public BodyType getDefaultBodyType(CustomContentEntityObject pluginContentEntityObject) {
        return BodyType.RAW;
    }

    public Optional<String> excerpt(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.of(GeneralUtil.makeFlatSummary((String)this.getUnquotedTextForSummary(pluginContentEntityObject), null));
    }

    public String getUnquotedTextForSummary(CustomContentEntityObject pluginContentEntityObject) {
        ContentBackedMail mail = ContentBackedMail.newInstance(pluginContentEntityObject);
        StringBuilder buf = new StringBuilder();
        String lastLine = "";
        String lastTry = "";
        try {
            String line;
            String body = mail.getMessageBody();
            BufferedReader r = new BufferedReader(new StringReader(body));
            State state = State.START;
            boolean reading = true;
            while (reading && (line = r.readLine()) != null && !"--".equals(line = line.trim())) {
                switch (state.ordinal()) {
                    case 0: {
                        if (line.isEmpty() || !Character.isLetterOrDigit(line.charAt(0))) break;
                        lastLine = line;
                        state = State.POSSIBLE;
                        break;
                    }
                    case 1: {
                        if (line.isEmpty()) break;
                        if (!Character.isLetterOrDigit(line.charAt(0))) {
                            state = State.NEXT;
                            break;
                        }
                        buf.append(lastLine).append(" ");
                        buf.append(line).append(" ");
                        state = State.UNTIL;
                        break;
                    }
                    case 2: {
                        if (line.isEmpty() || !Character.isLetterOrDigit(line.charAt(0))) break;
                        buf.append(line).append(" ");
                        state = State.UNTIL;
                        break;
                    }
                    case 3: {
                        if (!line.isEmpty() && !Character.isLetterOrDigit(line.charAt(0)) || line.isEmpty() && buf.length() > 80) {
                            if (buf.length() > 80) {
                                reading = false;
                            }
                            if (buf.length() > lastTry.length()) {
                                lastTry = buf.toString();
                            }
                            state = State.NEXT;
                            buf.setLength(0);
                            break;
                        }
                        buf.append(line).append(" ");
                    }
                }
            }
        }
        catch (IOException e) {
            log.info("Error getting unquoted mail text: {}", (Object)e.getMessage());
        }
        if (lastTry.isEmpty() && !lastLine.isEmpty()) {
            lastTry = lastLine;
        }
        if (lastTry.length() < buf.length()) {
            lastTry = buf.toString();
        }
        if (lastTry.isEmpty()) {
            return mail.getMessageBody();
        }
        return lastTry;
    }

    public static enum State {
        START,
        POSSIBLE,
        NEXT,
        UNTIL;

    }
}

