/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.content;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.mail.archive.ConfluenceMailAddress;
import com.atlassian.confluence.mail.archive.Mail;
import com.atlassian.confluence.mail.archive.content.ContentBackedMail;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.rss.AbstractContentEntityRenderSupport;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import io.atlassian.util.concurrent.Timeout;
import java.util.Map;

public class MailFeedSupport
extends AbstractContentEntityRenderSupport<CustomContentEntityObject> {
    @ComponentImport
    private SettingsManager importSettingsManager;
    @ComponentImport
    private UserAccessor importUserAccessor;
    @ComponentImport
    private WebResourceManager importWebResourceManager;
    @ComponentImport
    private WikiStyleRenderer importWikiStyleRenderer;
    @ComponentImport
    private Renderer importRenderer;
    @ComponentImport
    private VelocityHelperService velocityHelperService;

    private Mail getMail(RssRenderItem item) {
        return ContentBackedMail.newInstance((CustomContentEntityObject)item.getEntity());
    }

    public String getTitle(RssRenderItem<? extends CustomContentEntityObject> item) {
        Mail mail = this.getMail(item);
        return mail.getSubject() + " " + this.getText("rss.template.from") + ": " + this.getSender(mail);
    }

    public String renderedContext(RssRenderItem<? extends CustomContentEntityObject> item, Timeout timeout) {
        Mail mail = this.getMail(item);
        Map contextMap = this.contextMap(item, timeout);
        contextMap.put("entity", mail.getEntity());
        contextMap.put("mail", mail);
        contextMap.put("content", GeneralUtil.plain2html((String)mail.getMessageBody()));
        return this.velocityHelperService.getRenderedTemplate("templates/mail-archive/rss/mail-rss-content.vm", contextMap);
    }

    public String getSender(Mail mail) {
        ConfluenceMailAddress address = mail.getFrom();
        return this.getSender(address);
    }

    public String getSender(ConfluenceMailAddress address) {
        if (address == null) {
            return this.getText("anonymous.name");
        }
        try {
            return address.getSender();
        }
        catch (Exception e) {
            return this.getText("invalid.email.address");
        }
    }

    public void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }
}

