/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.content;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.mail.archive.content.ContentBackedMail;
import com.atlassian.confluence.mail.archive.content.MailArchivingMappings;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class MailSearchExtractor
implements Extractor2 {
    public StringBuilder extractText(Object searchable) {
        return new StringBuilder();
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        if (searchable instanceof CustomContentEntityObject) {
            CustomContentEntityObject contentEntityObject = (CustomContentEntityObject)searchable;
            if (!ContentBackedMail.isMailContentEntity(contentEntityObject)) {
                return resultBuilder.build();
            }
            ContentBackedMail mail = ContentBackedMail.newInstance(contentEntityObject);
            resultBuilder.add((Object)MailArchivingMappings.CANONICAL_SUBJECT.createField(mail.getCanonicalSubject()));
            resultBuilder.add((Object)MailArchivingMappings.MESSAGE_ID.createField(mail.getMessageId()));
            resultBuilder.add((Object)MailArchivingMappings.IN_REPLY_TO.createField(mail.getInReplyTo()));
            mail.getReferences().forEach(ref -> resultBuilder.add((Object)MailArchivingMappings.REFERENCES.createField(ref)));
            resultBuilder.add((Object)MailArchivingMappings.FROM.createField(mail.getFrom().toString()));
            mail.getRecipients().forEach(recipient -> resultBuilder.add((Object)MailArchivingMappings.RECIPIENTS.createField(recipient.toString())));
        }
        return resultBuilder.build();
    }
}

