/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.plugin.PluginUpgradeFinalizationTask;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandanaRemovalUpgradeTask
implements PluginUpgradeFinalizationTask {
    private static final int BUILD_NUMBER = 3;
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private BandanaManager bandanaManager;
    private final SpaceService spaceService;
    private final SpacePropertyService spacePropertyService;
    private final ObjectMapper objectMapper = new ConfluenceJsonObjectMapper();
    private final PermissionManager permissionManager;

    public BandanaRemovalUpgradeTask(@ComponentImport BandanaManager bandanaManager, @ComponentImport SpaceService spaceService, @ComponentImport SpacePropertyService spacePropertyService, @ComponentImport PermissionManager permissionManager) {
        this.bandanaManager = bandanaManager;
        this.spaceService = spaceService;
        this.spacePropertyService = spacePropertyService;
        this.permissionManager = permissionManager;
    }

    public int getBuildNumber() {
        return 3;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrate Bandana records to Plugin Settings.";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.info("Migrating Bandana records in confluence-inbound-email.");
        boolean isCacheInitialized = ThreadLocalCache.isInit();
        if (!isCacheInitialized) {
            ThreadLocalCache.init();
        }
        try {
            this.permissionManager.withExemption(this::migrateBandanaRecords);
        }
        finally {
            if (!isCacheInitialized) {
                ThreadLocalCache.dispose();
            }
        }
        log.info("Upgrade task for migrating Bandana records is completed.");
        return List.of();
    }

    private void migrateBandanaRecords() {
        PageResponse spaces = this.spaceService.find(new Expansion[0]).withType(SpaceType.GLOBAL).fetchMany((PageRequest)new SimplePageRequest(0, Integer.MAX_VALUE));
        for (Space space : spaces.getResults()) {
            NoParentBandanaContext bandanaContext = new NoParentBandanaContext(space.getKey());
            List accounts = (List)this.bandanaManager.getValue((BandanaContext)bandanaContext, "atlassian.confluence.space.mailaccounts");
            if (accounts == null || accounts.isEmpty()) {
                log.info("No mail accounts found for space {}", (Object)space.getKey());
                continue;
            }
            try {
                String persistedAccount = this.objectMapper.writeValueAsString((Object)accounts);
                JsonSpaceProperty property = ((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(space).key("atlassian.confluence.space.mailaccounts")).value(new JsonString(persistedAccount))).build();
                this.spacePropertyService.create(property);
            }
            catch (JsonProcessingException | IllegalArgumentException e) {
                log.warn("Failed to persist accounts for space {}.", (Object)space.getKey(), (Object)e);
            }
            catch (Exception e) {
                log.error("Unexpected error while migrating mail accounts for space {}.", (Object)space.getKey(), (Object)e);
                throw e;
            }
        }
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-mail-archiving";
    }
}

