/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.upgrade;

import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.mail.archive.MailAccount;
import com.atlassian.confluence.mail.archive.MailAccountManager;
import com.atlassian.confluence.plugin.PluginUpgradeFinalizationTask;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.sal.api.message.Message;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureMailAccountSecretsUpgradeTask
implements PluginUpgradeFinalizationTask {
    private static final int BUILD_NUMBER = 1;
    private static final Logger log = LoggerFactory.getLogger(SecureMailAccountSecretsUpgradeTask.class);
    private final MailAccountManager mailAccountManager;
    private final SpaceManager spaceManager;

    public SecureMailAccountSecretsUpgradeTask(MailAccountManager mailAccountManager, SpaceManager spaceManager) {
        this.mailAccountManager = mailAccountManager;
        this.spaceManager = spaceManager;
    }

    public int getBuildNumber() {
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Secure passwords for configured mail accounts.";
    }

    @Nullable
    public Collection<Message> doUpgrade() {
        if (SecretServiceState.DISABLED == SecretService.getState()) {
            log.info("Skipping the securing of passwords for mail accounts.");
            return Collections.emptyList();
        }
        log.info("Re-saving mail account configurations.");
        ListBuilder spacesListBuilder = this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
        for (List spaces : spacesListBuilder) {
            for (Space space : spaces) {
                List<MailAccount> mailAccounts = this.mailAccountManager.getMailAccounts(space);
                if (mailAccounts.isEmpty()) continue;
                MailAccount mailAccount = mailAccounts.get(0);
                this.mailAccountManager.updateAccount(space, mailAccount);
            }
        }
        log.info("Upgrade task for securing mail account passwords is completed.");
        return Collections.emptyList();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-mail-archiving";
    }
}

