/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class MapAndKeyValuePairDeserializer
extends MapDeserializer {
    public MapAndKeyValuePairDeserializer(MapDeserializer src) {
        super(src);
    }

    public MapAndKeyValuePairDeserializer(JavaType mapType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(mapType, valueInstantiator, keyDeser, valueDeser, valueTypeDeser);
    }

    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return this.deserializeMapKeyValueHierarchy(jp, ctxt, null);
        }
        return super.deserialize(jp, ctxt);
    }

    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return this.deserializeMapKeyValueHierarchy(jp, ctxt, result);
        }
        return super.deserialize(jp, ctxt, result);
    }

    private Map<Object, Object> deserializeMapKeyValueHierarchy(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> map) throws IOException {
        jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.END_ARRAY) {
            return map != null ? map : Collections.emptyMap();
        }
        if (map == null) {
            map = (Map)this._valueInstantiator.createUsingDefault(ctxt);
        }
        while (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            this.deserializeKeyValue(jp, ctxt, map);
        }
        if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            ctxt.handleUnexpectedToken(this.getMapClass(), jp);
        }
        return map;
    }

    private void deserializeKeyValue(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> map) throws IOException {
        jp.nextToken();
        String key = null;
        Map<Object, Object> value = null;
        block10: while (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            jp.nextToken();
            switch (name) {
                case "key": {
                    key = jp.getText();
                    jp.nextToken();
                    continue block10;
                }
                case "value": {
                    value = this.readValue(jp, ctxt);
                    jp.nextToken();
                    continue block10;
                }
                case "fields": {
                    value = this.deserializeMapKeyValueHierarchy(jp, ctxt, null);
                    continue block10;
                }
            }
            ctxt.handleUnexpectedToken(this.getMapClass(), jp);
        }
        if (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            ctxt.handleUnexpectedToken(this.getMapClass(), jp);
        }
        jp.nextToken();
        if (key != null) {
            map.put(key, value);
        }
    }

    private Object readValue(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (this._valueTypeDeserializer == null) {
            return this._valueDeserializer.deserialize(jp, ctxt);
        }
        return this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
    }
}

