/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.pagination.NavigablePageResponse;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.permissions.ContentRestrictionsPageResponse;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncPageResponse;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.services.RestEntityFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RestEntityConverter {
    private final RestEntityFactory restEntityFactory;

    public RestEntityConverter(RestEntityFactory restEntityFactory) {
        this.restEntityFactory = restEntityFactory;
    }

    public Object convert(Object entity) {
        return this.convert(entity, SchemaType.REST);
    }

    public Object convert(Object entity, SchemaType schemaType) {
        if (this.isEnrichableList(entity)) {
            return this.convertToRestEntityList((PageResponse)entity, schemaType);
        }
        if (entity != null && this.isEnrichableEntity(entity.getClass())) {
            return this.restEntityFactory.create(entity, schemaType == SchemaType.GRAPHQL);
        }
        return entity;
    }

    public boolean isEnrichableList(Class listType) {
        return RestList.class.isAssignableFrom(listType) || PageResponse.class.isAssignableFrom(listType);
    }

    public boolean isEnrichableEntity(Class entityType) {
        return entityType.isAnnotationPresent(RestEnrichable.class);
    }

    private boolean isEnrichableList(Object entity) {
        return entity instanceof RestList || entity instanceof PageResponse && RestEnrichable.Helper.isAnnotationOnClass((Object)entity);
    }

    private RestList convertToRestEntityList(PageResponse initialList, SchemaType schemaType) {
        ArrayList<Object> listBuilder = new ArrayList<Object>();
        for (Object entity : initialList) {
            listBuilder.add(this.convert(entity, schemaType));
        }
        List builtList = Collections.unmodifiableList(listBuilder);
        RestList.Builder restListBuilder = RestList.newRestList((PageRequest)initialList.getPageRequest()).results(builtList, initialList.getNextCursor(), initialList.getPrevCursor(), initialList.hasMore());
        if (initialList instanceof NavigablePageResponse) {
            NavigablePageResponse navigablePageResponse = (NavigablePageResponse)initialList;
            restListBuilder.navigationAware(navigablePageResponse.getNavigationBuilder());
        }
        RestList restList = restListBuilder.build();
        initialList.getTotalCount().ifPresent(totalResult -> restList.putProperty("totalSize", totalResult));
        if (initialList instanceof SearchPageResponse) {
            SearchPageResponse searchPageResponse = (SearchPageResponse)initialList;
            restList.putProperty("totalSize", (Object)searchPageResponse.totalSize());
            restList.putProperty("cqlQuery", (Object)searchPageResponse.getCqlQuery());
            restList.putProperty("searchDuration", (Object)searchPageResponse.getSearchDuration());
            if (searchPageResponse.archivedResultCount().isPresent()) {
                restList.putProperty("archivedResultCount", searchPageResponse.archivedResultCount().get());
            }
        }
        if (initialList instanceof IncrementalSyncPageResponse) {
            IncrementalSyncPageResponse incrementalSyncPageResponse = (IncrementalSyncPageResponse)initialList;
            restList.putProperty("incrementalSynchronisationAvailable", (Object)incrementalSyncPageResponse.isIncrementalSynchronisationAvailable());
        }
        if (initialList instanceof ContentRestrictionsPageResponse) {
            ContentRestrictionsPageResponse restrictionsResponse = (ContentRestrictionsPageResponse)initialList;
            restList.putProperty("links", (Object)restrictionsResponse.getLinks());
            restList.putProperty("restrictionsHash", (Object)restrictionsResponse.getRestrictionsHash());
        }
        if (initialList instanceof RestList) {
            restList.putProperties(((RestList)initialList).properties());
        }
        return restList;
    }
}

