/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.activeobjects;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.InitExecutorServiceProvider;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceInitExecutorServiceProvider
implements InitExecutorServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceInitExecutorServiceProvider.class);
    private final DataSourceProvider dataSourceProvider;
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    @VisibleForTesting
    final InitExecutorServiceProvider defaultInitExecutorServiceProvider;

    public ConfluenceInitExecutorServiceProvider(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, DataSourceProvider dataSourceProvider, InitExecutorServiceProvider defaultInitExecutorServiceProvider) {
        this.threadLocalDelegateExecutorFactory = Objects.requireNonNull(threadLocalDelegateExecutorFactory);
        this.dataSourceProvider = Objects.requireNonNull(dataSourceProvider);
        this.defaultInitExecutorServiceProvider = Objects.requireNonNull(defaultInitExecutorServiceProvider);
    }

    public @NonNull ExecutorService initExecutorService() {
        DatabaseType databaseType = this.dataSourceProvider.getDatabaseType();
        if (databaseType == DatabaseType.HSQL) {
            logger.debug("creating HSQL snowflake init executor");
            return this.threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        return this.defaultInitExecutorServiceProvider.initExecutorService();
    }
}

