/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Optional;

public enum TaskStatus {
    UNCHECKED("incomplete"),
    CHECKED("complete");

    private final String displayedText;

    private TaskStatus(String displayedText) {
        this.displayedText = displayedText;
    }

    public String getDisplayedText() {
        return this.displayedText;
    }

    @JsonCreator
    public static TaskStatus create(String displayText) {
        if ("incomplete".equals(displayText) || "UNCHECKED".equals(displayText)) {
            return UNCHECKED;
        }
        if ("complete".equals(displayText) || "CHECKED".equals(displayText)) {
            return CHECKED;
        }
        return null;
    }

    public static TaskStatus parse(String status) {
        return Optional.ofNullable(TaskStatus.create(status)).orElseThrow(IllegalArgumentException::new);
    }
}

