/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.filters;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class InlineTasksReadOnlyAccessRequestFilter
implements ContainerRequestFilter {
    private final AccessModeService accessModeService;

    public InlineTasksReadOnlyAccessRequestFilter(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            return;
        }
        if (this.isMutativeMethod(containerRequestContext.getMethod())) {
            throw new ReadOnlyException();
        }
    }

    private boolean isMutativeMethod(String method) {
        return StringUtils.equalsAny((CharSequence)method, (CharSequence[])new CharSequence[]{"POST", "PUT", "DELETE"});
    }
}

