/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.notification;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.tasklist.TaskModfication;
import com.atlassian.confluence.plugins.tasklist.notification.TaskRenderService;
import com.atlassian.confluence.plugins.tasklist.notification.api.TaskPayload;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractTaskNotificationContextFactory
extends RenderContextProviderTemplate<TaskPayload> {
    private static final Function<TaskModfication, TaskModfication.Operation> TO_OPERATION_FROM_TASK = TaskModfication::getTaskOperation;
    private final UserAccessor userAccessor;
    private final I18NBeanFactory beanFactory;
    private final LocaleManager localeManager;
    private final TaskRenderService taskRenderService;
    private final ContentService contentService;
    private final NotificationUserService notificationUserService;

    public AbstractTaskNotificationContextFactory(UserAccessor userAccessor, I18NBeanFactory beanFactory, LocaleManager localeManager, TaskRenderService taskRenderService, ContentService contentService, NotificationUserService notificationUserService) {
        super(TaskPayload.class);
        this.userAccessor = userAccessor;
        this.beanFactory = beanFactory;
        this.localeManager = localeManager;
        this.taskRenderService = taskRenderService;
        this.contentService = contentService;
        this.notificationUserService = notificationUserService;
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<TaskPayload> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        throw new RuntimeException("This factory exposes content, thus recipient has to be provided in order to perform a VIEW permission check.");
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<TaskPayload> simpleSendTaskPayloadNotification, ServerConfiguration configuration, RoleRecipient recipient) {
        TaskPayload payload = (TaskPayload)simpleSendTaskPayloadNotification.getPayload();
        ConfluenceUser recipientUser = this.userAccessor.getUserByKey(recipient.getUserKey());
        User modifier = this.notificationUserService.findUserByKey((User)recipientUser, payload.getOriginatorUserKey());
        I18NBean i18NBean = this.beanFactory.getI18NBean(this.localeManager.getLocale((User)recipientUser));
        NotificationContext context = new NotificationContext();
        Iterable<TaskModfication> tasks = payload.getTasks().get(recipient.getUserKey());
        Content content = (Content)this.contentService.find(new Expansion[0]).withId(payload.getContentId()).fetch().orElseThrow(() -> new RuntimeException(String.format("Could not read content for content id %d", payload.getContentId().asLong())));
        ListMultimap<TaskModfication.Operation, TaskModfication> categorisedTasks = this.renderTask(tasks, content, recipientUser);
        context.put("subjectKey", (Object)("inline-tasks-update.mail.subject." + (Iterables.isEmpty((Iterable)Iterables.filter(tasks, AbstractTaskNotificationContextFactory.with(TaskModfication.Operation.ASSIGNED))) ? "updated" : "assigned")));
        context.put("subjectFullName", (Object)(modifier != null ? modifier.getFullName() : i18NBean.getText("anonymous.name")));
        context.put("modifier", (Object)modifier);
        context.put("categorizedTasks", this.getTaskMapWithStringKeys(categorisedTasks.asMap()));
        context.put("numberOfTasks", (Object)Iterables.size(tasks));
        context.put("content", (Object)content);
        context.put("contentLink", content.getLinks().get(LinkType.WEB_UI));
        if (categorisedTasks.keys().size() > 1) {
            context.put("headerActionString", (Object)"tasks.mail.templates.multiple.actions");
        } else {
            context.put("headerActionString", (Object)((TaskModfication.Operation)((Object)categorisedTasks.keySet().iterator().next())).getI18nKey());
        }
        return Optional.of(context.getMap());
    }

    private Map<String, Collection<TaskModfication>> getTaskMapWithStringKeys(Map<TaskModfication.Operation, Collection<TaskModfication>> categorisedTasks) {
        HashMap<String, Collection<TaskModfication>> categorisedTasksMap = new HashMap<String, Collection<TaskModfication>>();
        for (TaskModfication.Operation operation : categorisedTasks.keySet()) {
            categorisedTasksMap.put(operation.name(), categorisedTasks.get((Object)operation));
        }
        return categorisedTasksMap;
    }

    protected abstract ListMultimap<TaskModfication.Operation, TaskModfication> renderTask(Iterable<TaskModfication> var1, Content var2, ConfluenceUser var3);

    protected TaskRenderService getTaskRenderService() {
        return this.taskRenderService;
    }

    protected Function<TaskModfication, TaskModfication.Operation> byOperation() {
        return TO_OPERATION_FROM_TASK;
    }

    private static Predicate<TaskModfication> with(@Nonnull TaskModfication.Operation operation) {
        return taskUpdate -> taskUpdate.getTaskOperation() == operation;
    }
}

