/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.notification;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.plugins.tasklist.TaskModfication;
import com.atlassian.confluence.plugins.tasklist.notification.api.TaskPayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public class SimpleTaskPayload
implements TaskPayload {
    private final Map<UserKey, Iterable<TaskModfication>> tasks;
    private final String originatingUserKey;
    private final ContentId contentId;

    public SimpleTaskPayload() {
        this.originatingUserKey = null;
        this.contentId = null;
        this.tasks = null;
    }

    @JsonCreator
    public SimpleTaskPayload(@JsonProperty(value="tasks") Map<UserKey, List<TaskModfication>> tasks, @JsonProperty(value="originatingUserKey") String originatingUserKey, @JsonProperty(value="contentId") ContentId contentId) {
        this.originatingUserKey = originatingUserKey;
        this.contentId = contentId;
        ImmutableMap.Builder taskBuilder = ImmutableMap.builder();
        for (Map.Entry<UserKey, List<TaskModfication>> entry : tasks.entrySet()) {
            taskBuilder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.tasks = taskBuilder.build();
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public Map<UserKey, Iterable<TaskModfication>> getTasks() {
        return this.tasks;
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return Optional.ofNullable(this.originatingUserKey).map(UserKey::new);
    }
}

