/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.report.searchindex;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.mapping.LongFieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.StringFieldMapping;
import com.atlassian.confluence.plugins.tasklist.ao.AOInlineTask;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.InlineTaskFieldMappings;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.ContentPermissionCalculator;
import com.atlassian.confluence.search.v2.lucene.LuceneUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class InlineTaskSearchDocumentFactory {
    final ContentPermissionCalculator contentPermissionCalculator;
    final UserAccessor userAccessor;

    public InlineTaskSearchDocumentFactory(ContentPermissionCalculator contentPermissionCalculator, UserAccessor userAccessor) {
        this.contentPermissionCalculator = contentPermissionCalculator;
        this.userAccessor = userAccessor;
    }

    public AtlassianDocument buildDocument(ContentEntityObject content, AOInlineTask task) {
        ConfluenceUser assigneeUser;
        Preconditions.checkNotNull((Object)content, (Object)"Content entity object can't be null");
        Preconditions.checkNotNull((Object)task, (Object)"Task can't be null");
        AtlassianDocument document = new AtlassianDocument();
        document.setId(Long.toString(task.getGlobalId()));
        document.addField(InlineTaskFieldMappings.GLOBAL_ID.createField(Long.toString(task.getGlobalId())));
        document.addField(InlineTaskFieldMappings.TASK_ID.createField(Long.toString(task.getId())));
        if (StringUtils.isNotEmpty((CharSequence)content.getTitle())) {
            document.addField(InlineTaskFieldMappings.PAGE_TITLE.createField(content.getTitle()));
            document.addField(InlineTaskFieldMappings.CASE_INSENSITIVE_PAGE_TITLE.createField(content.getTitle().toLowerCase()));
        }
        document.addField(InlineTaskFieldMappings.TASK_STATUS.createField(task.getTaskStatus().name()));
        if (StringUtils.isNotEmpty((CharSequence)task.getBody())) {
            document.addField(InlineTaskFieldMappings.TASK_BODY.createField(task.getBody()));
        }
        ConfluenceUser confluenceUser = assigneeUser = StringUtils.isNotEmpty((CharSequence)task.getAssigneeUserKey()) ? this.userAccessor.getUserByKey(new UserKey(task.getAssigneeUserKey())) : null;
        if (assigneeUser != null) {
            document.addField(InlineTaskFieldMappings.ASSIGNEE_KEY.createField(task.getAssigneeUserKey()));
            document.addField(InlineTaskFieldMappings.ASSIGNEE_NAME.createField(assigneeUser.getFullName()));
            document.addField(InlineTaskFieldMappings.ASSIGNEE.createField(assigneeUser.getName()));
        }
        document.addField(InlineTaskFieldMappings.ASSIGNEE_NAME_EMPTY_VALUES_LAST.createField(this.getAssigneeNameEmptyStringsLast(assigneeUser != null ? assigneeUser.getFullName() : null)));
        if (StringUtils.isNotEmpty((CharSequence)task.getCreatorUserKey())) {
            document.addField(InlineTaskFieldMappings.CREATOR_KEY.createField(task.getCreatorUserKey()));
        }
        document.addField(InlineTaskFieldMappings.CONTENT_ID.createField(String.valueOf(content.getId())));
        for (Label label : content.getLabels()) {
            document.addField(InlineTaskFieldMappings.LABELS.createField(label.getName()));
        }
        this.addDateField(document, task.getCreateDate(), InlineTaskFieldMappings.CREATE_DATE, InlineTaskFieldMappings.CREATE_DATE_MS, null);
        this.addDateField(document, task.getDueDate(), InlineTaskFieldMappings.DUE_DATE, InlineTaskFieldMappings.DUE_DATE_MS, InlineTaskFieldMappings.DUE_DATE_EMPTY_VALUES_LAST_MS);
        this.addAncestors(document, content);
        this.addSpaceKeyAndId(document, content);
        Collection permissions = this.contentPermissionCalculator.calculate(content);
        document.addFields(InlineTaskFieldMappings.PERMISSION_SETS.createFields(permissions));
        return document;
    }

    private String getAssigneeNameEmptyStringsLast(String userName) {
        return StringUtils.isEmpty((CharSequence)userName) ? "1" : "0." + userName;
    }

    private void addDateField(AtlassianDocument document, Date date, StringFieldMapping humanReadableFieldMapping, LongFieldMapping dateInMillisecondsFieldMapping, LongFieldMapping dateEmptyValuesLastInMillisecondsFieldMapping) {
        if (dateEmptyValuesLastInMillisecondsFieldMapping != null) {
            document.addField(dateEmptyValuesLastInMillisecondsFieldMapping.createField(date != null ? date.getTime() : Long.MAX_VALUE));
        }
        if (date == null) {
            return;
        }
        document.addField(humanReadableFieldMapping.createField(LuceneUtils.dateToString((Date)date)));
        document.addField(dateInMillisecondsFieldMapping.createField(date.getTime()));
    }

    private void addAncestors(AtlassianDocument document, ContentEntityObject content) {
        if (content instanceof Page) {
            Collection<Long> ancestors = this.getPageAncestors((Page)content);
            ancestors.forEach(ancestorId -> document.addField(InlineTaskFieldMappings.ANCESTOR_IDS.createField(String.valueOf(ancestorId))));
        } else {
            document.addField(InlineTaskFieldMappings.ANCESTOR_IDS.createField(String.valueOf(content.getId())));
        }
    }

    private Collection<Long> getPageAncestors(Page content) {
        ArrayList<Long> ancestors = new ArrayList<Long>();
        while (content != null) {
            ancestors.add(content.getId());
            content = content.getParent();
        }
        return ancestors;
    }

    private void addSpaceKeyAndId(AtlassianDocument document, ContentEntityObject content) {
        Space space;
        if (content instanceof Spaced && (space = ((Spaced)content.getLatestVersion()).getSpace()) != null) {
            document.addField(InlineTaskFieldMappings.SPACE_ID.createField(Long.toString(space.getId())));
            if (StringUtils.isNotBlank((CharSequence)space.getKey())) {
                document.addField(InlineTaskFieldMappings.SPACE_KEY.createField(space.getKey()));
                return;
            }
        }
        document.addField(InlineTaskFieldMappings.IN_SPACE.createField(false));
    }
}

