/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction;

import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.SearchIndexActionWithNumberOfIds;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteContentIdAction
implements SearchIndexActionWithNumberOfIds {
    private static final Logger log = LoggerFactory.getLogger(DeleteContentIdAction.class);
    private final Collection<Long> pageIds;

    public DeleteContentIdAction(Collection<Long> pageIds) {
        this.pageIds = pageIds;
    }

    public void accept(SearchIndexWriter searchIndexWriter) throws IOException {
        log.trace("Removing tasks from {} pages", (Object)this.pageIds.size());
        Set stringIds = this.pageIds.stream().map(id -> Long.toString(id)).collect(Collectors.toSet());
        searchIndexWriter.delete((SearchQuery)new TermSetQuery("contentId", stringIds));
    }

    @Override
    public int getNumberOfIds() {
        return this.pageIds.size();
    }
}

