/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.indexqueue;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.ao.AOInlineTask;
import com.atlassian.confluence.plugins.tasklist.ao.dao.InlineTaskDao;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.InlineTaskSearchDocumentFactory;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.InlineTaskSearchIndexAccessor;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.AddSearchDocumentForInlineTaskAction;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.DeleteContentIdAction;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.DeletePageWithDescendantsAction;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.DeleteTasksAction;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexaction.SearchIndexActionWithNumberOfIds;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.FullReIndexer;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.TaskReportIndexPersistedStateService;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.indexqueue.IndexQueueProcessor;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.task.InlineTaskIndexTaskType;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.task.TaskLevel;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IndexQueueProcessorImpl
implements IndexQueueProcessor {
    private static final Logger log = LoggerFactory.getLogger(IndexQueueProcessorImpl.class);
    private static final String SELF_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-inline-tasks";
    public static final String INLINE_TASK_INDEX_BATCH_SIZE = "confluence.plugins.confluence-inline-tasks.index.batch.size";
    static final JournalIdentifier JOURNAL_ID = new JournalIdentifier("task_report_index");
    private final JournalService journalService;
    private final InlineTaskSearchIndexAccessor inlineTaskSearchIndexAccessor;
    private final FullReIndexer fullReIndexer;
    private final InlineTaskSearchDocumentFactory inlineTaskSearchDocumentFactory;
    private final InlineTaskDao inlineTaskDao;
    private final EventPublisher eventPublisher;
    private final PageManager pageManager;
    private final ContentEntityManager contentEntityManager;
    private final TaskReportIndexPersistedStateService taskReportIndexPersistedStateService;
    private final AtomicBoolean pluginIsUpAndRunning = new AtomicBoolean();
    private final AtomicBoolean fullReindexRequiredOnCurrentNode = new AtomicBoolean();
    private final List<SearchIndexActionWithNumberOfIds> searchIndexActionsList = new ArrayList<SearchIndexActionWithNumberOfIds>();
    private final AtomicInteger processedEntries = new AtomicInteger();

    public IndexQueueProcessorImpl(@Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @Qualifier(value="indexJournalService") JournalService journalService, @ComponentImport EventPublisher eventPublisher, @ComponentImport PageManager pageManager, InlineTaskSearchIndexAccessor inlineTaskSearchIndexAccessor, FullReIndexer fullReIndexer, InlineTaskSearchDocumentFactory inlineTaskSearchDocumentFactory, InlineTaskDao inlineTaskDao, TaskReportIndexPersistedStateService taskReportIndexPersistedStateService) {
        this.contentEntityManager = contentEntityManager;
        this.journalService = (JournalService)Preconditions.checkNotNull((Object)journalService);
        this.eventPublisher = eventPublisher;
        this.pageManager = pageManager;
        this.inlineTaskSearchIndexAccessor = inlineTaskSearchIndexAccessor;
        this.fullReIndexer = fullReIndexer;
        this.inlineTaskDao = inlineTaskDao;
        this.inlineTaskSearchDocumentFactory = inlineTaskSearchDocumentFactory;
        this.taskReportIndexPersistedStateService = taskReportIndexPersistedStateService;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void teardown() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (!SELF_PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            return;
        }
        log.debug("Inline Task Plugin has been enabled. Task indexing queue processing is allowed.");
        this.pluginIsUpAndRunning.set(true);
    }

    private synchronized int processJournalEntries() {
        if (this.fullReindexRequiredOnCurrentNode.get()) {
            this.fullReindexRequiredOnCurrentNode.set(false);
            return this.fullReIndexer.reindexAllTasks();
        }
        boolean indexIsReady = this.taskReportIndexPersistedStateService.isIndexReady();
        this.processedEntries.set(0);
        this.searchIndexActionsList.clear();
        return (Integer)this.journalService.processNewEntries(JOURNAL_ID, this.getBatchSize(), entries -> {
            ImmutableList entriesAsList = ImmutableList.copyOf((Iterable)entries);
            boolean fullReindexRequired = entriesAsList.stream().anyMatch(entry -> InlineTaskIndexTaskType.valueOf(entry.getType()).equals((Object)InlineTaskIndexTaskType.REINDEX_ALL));
            try {
                if (fullReindexRequired) {
                    return EntryProcessorResult.success((Object)this.fullReIndexer.reindexAllTasks());
                }
                if (!indexIsReady) {
                    log.debug("Index is not ready. It was either failed on index recovery or was not created at all. Journal records will be skipped until a new 'full reindex' request received.");
                    return EntryProcessorResult.success((Object)entriesAsList.size());
                }
                this.handleSearchIndexActionsForAllIndexingLevels((List<JournalEntry>)entriesAsList);
                this.processIndexActions();
                return EntryProcessorResult.success((Object)this.processedEntries.get());
            }
            catch (Exception e) {
                log.warn("Failed to process the next batch of task", (Throwable)e);
                return EntryProcessorResult.failure((Object)0, (long)((JournalEntry)entriesAsList.get(entriesAsList.size() - 1)).getId());
            }
        });
    }

    private int getBatchSize() {
        return Integer.getInteger(INLINE_TASK_INDEX_BATCH_SIZE, 1000);
    }

    private void handleIndexAction(SearchIndexActionWithNumberOfIds indexAction) {
        this.handleIndexActions(Collections.singletonList(indexAction));
    }

    private void handleIndexActions(List<SearchIndexActionWithNumberOfIds> indexActions) {
        this.searchIndexActionsList.addAll(indexActions);
        if (this.searchIndexActionsList.size() >= this.getBatchSize()) {
            this.processIndexActions();
        }
    }

    private void processIndexActions() {
        if (this.searchIndexActionsList.isEmpty()) {
            return;
        }
        this.inlineTaskSearchIndexAccessor.withBatchUpdate(() -> this.searchIndexActionsList.forEach(arg_0 -> ((InlineTaskSearchIndexAccessor)this.inlineTaskSearchIndexAccessor).execute(arg_0)));
        this.processedEntries.addAndGet(this.searchIndexActionsList.stream().map(SearchIndexActionWithNumberOfIds::getNumberOfIds).reduce(0, Integer::sum));
        this.searchIndexActionsList.clear();
    }

    private void handleSearchIndexActionsForAllIndexingLevels(List<JournalEntry> entriesAsList) {
        Map<String, List<JournalEntry>> mapsOfEntriesByType = entriesAsList.stream().collect(Collectors.groupingBy(JournalEntry::getType));
        mapsOfEntriesByType.forEach((key, value) -> {
            InlineTaskIndexTaskType taskType = InlineTaskIndexTaskType.valueOf(key);
            this.handleActionsForParticularTaskType(taskType, (List<JournalEntry>)value);
        });
    }

    private void handleActionsForParticularTaskType(InlineTaskIndexTaskType taskType, List<JournalEntry> journalEntries) {
        Set<Long> idsToReindex = this.extractIdsFromJournalRecords(journalEntries);
        this.handleIndexAction(this.createDeleteAction(taskType.taskLevel, idsToReindex));
        if (taskType.modificationType.isAdd) {
            idsToReindex.forEach(id -> this.handleActionForAddingInlineTasksToTheSearchIndex(taskType.taskLevel, (Long)id));
        }
    }

    private Set<Long> extractIdsFromJournalRecords(List<JournalEntry> journalEntries) {
        return journalEntries.stream().map(entry -> {
            try {
                return Long.parseLong(entry.getMessage());
            }
            catch (Exception e) {
                log.error("unable to parse message (long value) for journal with id {}", (Object)entry.getId());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private SearchIndexActionWithNumberOfIds createDeleteAction(TaskLevel taskLevel, Set<Long> ids) {
        switch (taskLevel) {
            case TASK: {
                return new DeleteTasksAction(ids);
            }
            case ANCESTOR: {
                return new DeletePageWithDescendantsAction(ids);
            }
            case PAGE: {
                return new DeleteContentIdAction(ids);
            }
        }
        throw new IllegalArgumentException("Unexpected task level for removal: " + taskLevel.name());
    }

    @Override
    public synchronized int flushQueue() {
        if (!this.pluginIsUpAndRunning.get()) {
            log.debug("Queue will not be processed because the plugin is not ready yet.");
            return 0;
        }
        log.trace("Flushing task index queue...");
        StopWatch stopWatch = StopWatch.createStarted();
        int numberOfProcessedEntries = this.processJournalEntries();
        log.trace("Inline task index job flushed {} tasks. Duration: {}", (Object)numberOfProcessedEntries, (Object)stopWatch);
        return numberOfProcessedEntries;
    }

    @Override
    public void requestFullReindexOnCurrentNode() {
        this.fullReindexRequiredOnCurrentNode.set(true);
    }

    private void handleActionForAddingInlineTasksToTheSearchIndex(TaskLevel taskLevel, Long id) {
        switch (taskLevel) {
            case TASK: {
                this.handleActionForAddingSingleTask(id);
                break;
            }
            case PAGE: {
                this.handleActionsForAddingTasksFromPage(id);
                break;
            }
            case ANCESTOR: {
                this.handleActionForAddingTasksFromPageAndAllItsDescendants(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected task level for adding: " + taskLevel.name());
            }
        }
    }

    private void handleActionForAddingTasksFromPageAndAllItsDescendants(Long ancestorId) {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(ancestorId.longValue());
        if (contentEntityObject == null) {
            log.warn("Unable to find an ancestor page with id {}. Nothing will be indexed", (Object)ancestorId);
            return;
        }
        LinkedList<Long> pageIdsToProcess = new LinkedList<Long>();
        pageIdsToProcess.add(contentEntityObject.getId());
        while (!pageIdsToProcess.isEmpty()) {
            Long pageIdToProcess = (Long)pageIdsToProcess.pollLast();
            ContentEntityObject contentEntityObjectToProcess = this.contentEntityManager.getById(pageIdToProcess.longValue());
            this.handleActionsForAddingTasksFromPage(contentEntityObjectToProcess);
            if (!(contentEntityObjectToProcess instanceof Page)) continue;
            Page pageToProcess = (Page)contentEntityObjectToProcess;
            pageIdsToProcess.addAll(this.pageManager.getChildrenIds(pageToProcess));
        }
    }

    private void handleActionForAddingSingleTask(Long globalTaskId) {
        AOInlineTask aoInlineTask = this.inlineTaskDao.get(globalTaskId);
        if (aoInlineTask == null) {
            log.warn("Unable to find task with id {}. Nothing will be indexed", (Object)globalTaskId);
            return;
        }
        long contentId = aoInlineTask.getContentId();
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(contentId);
        if (contentEntityObject == null) {
            log.warn("Unable to find page with id {}. Nothing will be indexed", (Object)contentId);
            return;
        }
        this.handleIndexAction(new AddSearchDocumentForInlineTaskAction(this.inlineTaskSearchDocumentFactory, contentEntityObject, aoInlineTask));
    }

    private void handleActionsForAddingTasksFromPage(Long contentId) {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(contentId.longValue());
        if (contentEntityObject == null) {
            log.warn("Unable to find page with id {}. Nothing will be indexed", (Object)contentId);
            return;
        }
        this.handleActionsForAddingTasksFromPage(contentEntityObject);
    }

    private void handleActionsForAddingTasksFromPage(ContentEntityObject contentEntityObject) {
        if (contentEntityObject == null) {
            return;
        }
        Collection<AOInlineTask> tasks = this.inlineTaskDao.getByContentId(contentEntityObject.getId());
        if (tasks.isEmpty()) {
            return;
        }
        List<SearchIndexActionWithNumberOfIds> indexActions = tasks.stream().map(aoInlineTask -> new AddSearchDocumentForInlineTaskAction(this.inlineTaskSearchDocumentFactory, contentEntityObject, (AOInlineTask)aoInlineTask)).collect(Collectors.toList());
        this.handleIndexActions(indexActions);
    }
}

