/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.scheduling;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.indexqueue.IndexQueueProcessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="inlineTaskIndexQueueFlusherJob")
public class InlineTaskIndexQueueFlusherJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(InlineTaskIndexQueueFlusherJob.class);
    private final IndexQueueProcessor queue;

    @Autowired
    public InlineTaskIndexQueueFlusherJob(IndexQueueProcessor queue) {
        this.queue = queue;
    }

    public @Nullable JobRunnerResponse runJob(@ParametersAreNonnullByDefault JobRunnerRequest request) {
        try {
            this.queue.flushQueue();
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            log.error("Unable to run task report index flush job", (Throwable)e);
            return JobRunnerResponse.failed((String)e.getMessage());
        }
    }
}

