/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.confluence.plugins.tasklist.filters.InlineTasksReadOnlyAccessFilterDynamicBinding;
import com.atlassian.confluence.plugins.tasklist.rest.AbstractTaskResource;
import com.atlassian.confluence.plugins.tasklist.rest.BatchedTaskStatusUpdate;
import com.atlassian.confluence.plugins.tasklist.rest.TaskStatusUpdate;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Path(value="/task")
@AnonymousSiteAccess
@Component
@InlineTasksReadOnlyAccessFilterDynamicBinding
public class TaskResource
extends AbstractTaskResource {
    private static final String CONTENT_LOCK_PREFIX = "TaskResource";
    private final InlineTaskService inlineTaskService;

    private TaskResource() {
        this.inlineTaskService = null;
    }

    @Inject
    public TaskResource(UserAccessor userAccessor, SpacePermissionManager spm, InlineTaskService inlineTaskService) {
        super(userAccessor, spm);
        this.inlineTaskService = inlineTaskService;
    }

    @GET
    @Produces(value={"application/xml"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response doDefault() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Response setTaskStatus(long cid, String taskId, String status) {
        String stripedContentLock;
        String string = stripedContentLock = this.createStripedLockForContent(cid);
        synchronized (string) {
            return this.setTaskStatus(cid, taskId, new TaskStatusUpdate(status, "UNKNOWN"));
        }
    }

    private String createStripedLockForContent(long cid) {
        return (CONTENT_LOCK_PREFIX + cid).intern();
    }

    @POST
    @Path(value="/{contentId}/{taskId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setTaskStatus(@PathParam(value="contentId") long cid, @PathParam(value="taskId") String taskId, TaskStatusUpdate request) {
        PageUpdateTrigger decodedTrigger;
        TaskStatus decodedStatus;
        this.createRequestContext();
        if (request == null || request.getStatus() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid status").build();
        }
        try {
            decodedStatus = TaskStatus.valueOf(request.getStatus());
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid status").build();
        }
        try {
            decodedTrigger = request.getTrigger() == null ? PageUpdateTrigger.UNKNOWN : PageUpdateTrigger.valueOf((String)request.getTrigger());
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid trigger").build();
        }
        try {
            switch (this.inlineTaskService.setBatchedTaskStatus(cid, Map.of(taskId, decodedStatus), decodedTrigger)) {
                case SUCCESS: {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                case TASK_NOT_FOUND: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specified task not found").build();
                }
                case MERGE_CONFLICT: {
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Merge conflict while attempting to set status").build();
                }
                case NOT_PERMITTED: {
                    throw new NotPermittedException("Object not found, or you lack sufficient permission to view/edit the entity");
                }
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Received an unexpected response code from the Inline Task Service").build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (NotPermittedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/{contentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setBatchedTaskStatus(@PathParam(value="contentId") long cid, BatchedTaskStatusUpdate request) {
        PageUpdateTrigger decodedTrigger;
        this.createRequestContext();
        Map<String, String> taskStatuses = request.getTaskStatuses();
        if (taskStatuses == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request").build();
        }
        if (taskStatuses.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No tasks were given.").build();
        }
        HashMap<String, TaskStatus> taskStatusRequests = new HashMap<String, TaskStatus>();
        for (String taskId : taskStatuses.keySet()) {
            try {
                taskStatusRequests.put(taskId, TaskStatus.parse(taskStatuses.get(taskId)));
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid status for task with id: " + taskId)).build();
            }
        }
        try {
            decodedTrigger = request.getTrigger() == null ? PageUpdateTrigger.UNKNOWN : PageUpdateTrigger.valueOf((String)request.getTrigger());
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid trigger").build();
        }
        try {
            switch (this.inlineTaskService.setBatchedTaskStatus(cid, taskStatusRequests, decodedTrigger)) {
                case SUCCESS: {
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                case TASK_NOT_FOUND: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specified task not found").build();
                }
                case MERGE_CONFLICT: {
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Merge conflict while attempting to set status").build();
                }
                case NOT_PERMITTED: {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Object not found, or you lack sufficient permission to view/edit the entity").build();
                }
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Received an unexpected response code from the Inline Task Service").build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

